/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.JsonCopyHelper;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV3;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class SchemaV4 {
    public static Path getCombatConfigPath() {
        return Scorchful.getConfigDir().resolve("combat.json5");
    }

    public static Path getThirstConfigPath() {
        return Scorchful.getConfigDir().resolve("thirst.json5");
    }

    public static void run() throws IOException {
        JsonObject oldHeatingConfig = JsonCopyHelper.read(SchemaV3.getHeatingConfigPath());
        JsonObject oldCombatConfig = JsonCopyHelper.read(SchemaV4.getCombatConfigPath());
        JsonObject oldThirstConfig = JsonCopyHelper.read(SchemaV4.getThirstConfigPath());
        JsonObject itemConfig = new JsonObject();
        JsonCopyHelper.copyBooleanProperty(oldHeatingConfig, itemConfig, "enableTurtleArmorEffects");
        JsonCopyHelper.copyFloatProperty(oldHeatingConfig, itemConfig, "turtleArmorLungCapacityMultiplier");
        JsonCopyHelper.copyStringProperty(oldCombatConfig, itemConfig, "fireBallThrownType");
        JsonCopyHelper.copyDoubleProperty(oldCombatConfig, itemConfig, "fireProtectionHeatResistancePerLevel");
        JsonCopyHelper.copyFloatProperty(oldCombatConfig, itemConfig, "impalingDamagePerLevel");
        JsonCopyHelper.copyIntProperty(oldThirstConfig, itemConfig, "waterFromRefreshingFood");
        JsonCopyHelper.copyIntProperty(oldThirstConfig, itemConfig, "waterFromSustainingFood");
        JsonCopyHelper.copyIntProperty(oldThirstConfig, itemConfig, "waterFromHydratingFood");
        JsonCopyHelper.copyIntProperty(oldThirstConfig, itemConfig, "waterFromParchingFood");
        JsonCopyHelper.copyIntProperty(oldThirstConfig, itemConfig, "rehydrationDrinkSize");
        JsonCopyHelper.copyFloatProperty(oldThirstConfig, itemConfig, "maxRehydrationEfficiency");
        JsonCopyHelper.rename(itemConfig, "waterFromRefreshingFood", "refreshingWaterMultiplier");
        JsonCopyHelper.rename(itemConfig, "waterFromSustainingFood", "sustainingWaterMultiplier");
        JsonCopyHelper.rename(itemConfig, "waterFromHydratingFood", "hydratingWaterMultiplier");
        JsonCopyHelper.rename(itemConfig, "waterFromParchingFood", "parchingWaterMultiplier");
        JsonCopyHelper.rename(itemConfig, "rehydrationDrinkSize", "rehydrationDrinkSizeMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(itemConfig, "refreshingWaterMultiplier", 60);
        JsonCopyHelper.convertIntToFloatMultiplier(itemConfig, "sustainingWaterMultiplier", 120);
        JsonCopyHelper.convertIntToFloatMultiplier(itemConfig, "hydratingWaterMultiplier", 300);
        JsonCopyHelper.convertIntToFloatMultiplier(itemConfig, "parchingWaterMultiplier", 120);
        JsonCopyHelper.convertIntToFloatMultiplier(itemConfig, "rehydrationDrinkSizeMultiplier", 120);
        Path basePath = Scorchful.getConfigDir().resolve("common");
        Files.createDirectories(basePath, new FileAttribute[0]);
        Path path = basePath.resolve("item.json5");
        Files.writeString(path, (CharSequence)itemConfig.toString(), new OpenOption[0]);
        Files.writeString(SchemaV4.getCombatConfigPath(), (CharSequence)oldCombatConfig.toString(), new OpenOption[0]);
        Files.writeString(SchemaV4.getThirstConfigPath(), (CharSequence)oldThirstConfig.toString(), new OpenOption[0]);
        Files.delete(SchemaV3.getHeatingConfigPath());
    }

    private SchemaV4() {
    }
}

