/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.FloatSlider;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AccessibilitySettings {
    public static final Path PATH = Scorchful.getConfigDir().resolve("client/accessibility.json5");
    public static final ConfigClassHandler<AccessibilitySettings> HANDLER = ConfigClassHandler.createBuilder(AccessibilitySettings.class).id(Scorchful.id("client/accessibility")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    private static final String CATEGORY = "main";
    @AutoGen(category="main")
    @Translate.Name(value="Enable sound temperature effects")
    @TickBox
    @SerialEntry(comment="Toggle the sound effects of temperature, particularly the heart beat")
    boolean enableSoundTemperatureEffects = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable Heat Stroke post processing")
    @TickBox
    @SerialEntry(comment="Toggle the blur and wavey-ness screen effects from the Heat Stroke status effect.")
    boolean enableHeatStrokePostProcessing = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable Fear post processing")
    @TickBox
    @SerialEntry(comment="Toggle the darkening and desaturation screen effects from the Heat Stroke status effect.")
    boolean enableFearPostProcessing = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable Sun Hat shading")
    @TickBox
    @SerialEntry(comment="Toggle the darkening effect of the Sun Hat")
    boolean enableSunHatShading = true;
    @AutoGen(category="main")
    @Translate.Name(value="Sun Hat shade darkness")
    @FloatSlider(min=0.0f, max=1.0f, step=0.05f)
    @SerialEntry(comment="Controls the strength of how dark the sun hat shading is.")
    float sunHatShadeOpacity = 0.2f;

    public boolean enableSoundTemperatureEffects() {
        return this.enableSoundTemperatureEffects;
    }

    public boolean enableHeatStrokePostProcessing() {
        return this.enableHeatStrokePostProcessing;
    }

    public boolean enableFearPostProcessing() {
        return this.enableFearPostProcessing;
    }

    public float getSunHatShadeOpacity() {
        return this.enableSunHatShading ? this.sunHatShadeOpacity : 0.0f;
    }
}

