/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleField;
import dev.isxander.yacl3.config.v2.api.autogen.FloatField;
import dev.isxander.yacl3.config.v2.api.autogen.FloatSlider;
import dev.isxander.yacl3.config.v2.api.autogen.IntField;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;
import net.minecraft.class_3532;

public class EntityConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("common").resolve("entity.json5");
    public static final ConfigClassHandler<EntityConfig> HANDLER = ConfigClassHandler.createBuilder(EntityConfig.class).id(Scorchful.id("common/entity")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    public static final String EFFECTS_CATEGORY = "effects";
    public static final String SOAKING_CATEGORY = "soaking";
    @AutoGen(category="effects")
    @Translate.Name(value="Enable desert visions")
    @SerialEntry(comment="Toggles hallucinations when overheating in the desert like boats and flowers.")
    @TickBox
    boolean enableDesertVisions = true;
    @AutoGen(category="effects")
    @Translate.Name(value="Fear detection range multiplier")
    @SerialEntry(comment="How much to multiply an entity's (including players) hostile mob detection range by.")
    @DoubleField(min=0.0, max=128.0)
    double fearDetectionRangeMultiplier = 2.0;
    @AutoGen(category="soaking")
    @Translate.Name(value="Soaking from Splash Potions multiplier")
    @SerialEntry(comment="Multiplies the soaking points that are applied when an entity is hit with any Splash Potion.")
    @FloatSlider(min=0.0f, max=1.0f, step=0.05f)
    float soakingFromSplashPotionsMultiplier = 1.0f;
    @AutoGen(category="soaking")
    @Translate.Name(value="Touching water or rain wetness increase per tick")
    @SerialEntry(comment="How many soaking points to add when touching water or rain each tick. Note that submerging yourself in water will fully soak you, regardless of what this is set to.")
    @IntField
    int touchingWaterWetnessIncrease = 1;
    @AutoGen(category="soaking")
    @Translate.Name(value="On fire dry rate multiplier")
    @SerialEntry(comment="Multiplies the soaking points that are removed from an entity that is on fire each tick.")
    @FloatField
    float onFireDryRateMultiplier = 1.0f;

    public boolean enableDesertVisions() {
        return this.enableDesertVisions;
    }

    public double getFearDetectionRangeMultiplier() {
        return this.fearDetectionRangeMultiplier;
    }

    public int getSoakingFromSplashPotions() {
        return class_3532.method_15375((float)(300.0f * this.soakingFromSplashPotionsMultiplier));
    }

    public int getTouchingWaterWetnessIncrease() {
        return this.touchingWaterWetnessIncrease;
    }

    public int getOnFireDryDate() {
        return class_3532.method_15375((float)(3.0f * this.onFireDryRateMultiplier));
    }
}

