/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.components.RehydrationComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.EntityConfig;
import com.github.thedeathlycow.scorchful.mixin.accessor.EntityAccessor;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3486;

public final class SoakingEffects {
    public static final class_2960 REHYDRATION_TICK_PHASE = Scorchful.id("rehydration_tick");

    public static void initialize() {
        LivingEntitySoakingTickEvents.GET_SOAKING_CHANGE.register(SoakingEffects::getSoakingChange);
        LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE.addPhaseOrdering(REHYDRATION_TICK_PHASE, Event.DEFAULT_PHASE);
        LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE.register(REHYDRATION_TICK_PHASE, (context, soakingChange) -> {
            SoakingEffects.tickRehydration((EnvironmentTickContext<? extends class_1309>)context, soakingChange);
            return TriState.DEFAULT;
        });
    }

    private static int getSoakingChange(EnvironmentTickContext<? extends class_1309> context) {
        if (((class_1309)context.affected()).method_7325()) {
            return 0;
        }
        class_1309 entity = (class_1309)context.affected();
        if (entity.method_5777(class_3486.field_15517)) {
            return entity.thermoo$getMaxWetTicks();
        }
        EntityConfig config = ScorchfulConfig.getEntityConfig();
        int total = 0;
        total += SoakingEffects.getTouchingWaterChange(entity, config);
        return total -= SoakingEffects.getOnFireChange(entity, config);
    }

    private static int getTouchingWaterChange(class_1309 entity, EntityConfig config) {
        if (SoakingEffects.isTouchingWater(entity) || entity.method_55667().method_27852(class_2246.field_27097)) {
            return config.getTouchingWaterWetnessIncrease();
        }
        return 0;
    }

    private static int getOnFireChange(class_1309 entity, EntityConfig config) {
        return entity.method_5809() ? config.getOnFireDryDate() : 0;
    }

    private static void tickRehydration(EnvironmentTickContext<? extends class_1309> context, int wetChange) {
        TemperatureAware temperatureAware = context.affected();
        if (temperatureAware instanceof class_1657) {
            class_1657 player = (class_1657)temperatureAware;
            double rehydrationEfficiency = player.method_45325(SEntityAttributes.REHYDRATION_EFFICIENCY);
            RehydrationComponent component = (RehydrationComponent)ScorchfulComponents.REHYDRATION.get((Object)player);
            component.tickRehydration(rehydrationEfficiency, wetChange);
        }
    }

    private static boolean isTouchingWater(class_1309 entity) {
        if (entity.method_5799()) {
            return true;
        }
        return ((EntityAccessor)entity).scorchful$invokeIsBeingRainedOn() && !entity.method_24520(stack -> stack.method_31573(SItemTags.BLOCKS_RAIN_WHEN_HOLDING));
    }

    private SoakingEffects() {
    }
}

