package com.github.thedeathlycow.scorchful.api;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

/**
 * Event that is invoked after the water skin item successfully collects water from a water source such as a water block,
 * cauldron, or warped lily.
 */
@FunctionalInterface
public interface CollectWaterCallback {
    Event<CollectWaterCallback> EVENT = EventFactory.createArrayBacked(
            CollectWaterCallback.class,
            listeners -> (user, stack, sourcePos) -> {
                for (CollectWaterCallback listener : listeners) {
                    listener.onWaterCollected(user, stack, sourcePos);
                }
            }
    );

    /**
     * @param user      The player collecting water
     * @param stack     The water skin item stack
     * @param sourcePos The block position of the collection source
     */
    void onWaterCollected(class_1657 user, class_1799 stack, class_2338 sourcePos);
}