package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5620;
import net.minecraft.class_5712;

public class SandCauldronBehaviours {
    public static final class_5620.class_8821 SAND_CAULDRON_BEHAVIOUR = class_5620.method_32206("scorchful_sand_cauldron");
    public static final class_5620.class_8821 RED_SAND_CAULDRON_BEHAVIOUR = class_5620.method_32206("scorchful_red_sand_cauldron");

    public static final class_5620 EMPTY_SAND_CAULDRON = (state, world, pos, player, hand, stack) -> {
        return emptyBlockFromCauldron(
                state,
                world,
                pos,
                player,
                stack,
                class_1802.field_8858.method_7854(),
                class_3417.field_15144
        );
    };

    public static final class_5620 EMPTY_RED_SAND_CAULDRON = (state, world, pos, player, hand, stack) -> {
        return emptyBlockFromCauldron(
                state,
                world,
                pos,
                player,
                stack,
                class_1802.field_8200.method_7854(),
                class_3417.field_15144
        );
    };

    public static void initialize() {
        class_5620.field_27775.comp_1982().put(
                class_1802.field_8858,
                fillWithSand(
                        SBlocks.SAND_CAULDRON.method_9564()
                                .method_11657(SandCauldronBlock.LEVEL, SandCauldronBlock.MAX_LEVEL)
                )
        );

        class_5620.field_27775.comp_1982().put(
                class_1802.field_8200,
                fillWithSand(
                        SBlocks.RED_SAND_CAULDRON.method_9564()
                                .method_11657(SandCauldronBlock.LEVEL, SandCauldronBlock.MAX_LEVEL)
                )
        );

        if (SAND_CAULDRON_BEHAVIOUR.comp_1982() instanceof Object2ObjectOpenHashMap<class_1792, class_5620> sandCauldronOpenMap) {
            sandCauldronOpenMap.defaultReturnValue(EMPTY_SAND_CAULDRON);
        } else {
            Scorchful.LOGGER.error("Unable to register default sand cauldron behaviour");
        }

        if (RED_SAND_CAULDRON_BEHAVIOUR.comp_1982() instanceof Object2ObjectOpenHashMap<class_1792, class_5620> redSandCauldronOpenMap) {
            redSandCauldronOpenMap.defaultReturnValue(EMPTY_RED_SAND_CAULDRON);
        } else {
            Scorchful.LOGGER.error("Unable to register default red sand cauldron behaviour");
        }
    }

    /**
     * Fills a cauldron from a block item stack.
     *
     * <p>The block item  stack will be decremented in the player's
     * inventory.
     *
     * @param pos        the cauldron's position
     * @param world      the world where the cauldron is located
     * @param soundEvent the sound produced by filling
     * @param hand       the hand interacting with the cauldron
     * @param player     the interacting player
     * @param state      the filled cauldron state
     * @param stack      the block item stack in the player's hand
     * @return a {@linkplain class_1269#method_23665 successful} action result
     */
    public static class_1269 fillCauldronWithBlock(
            class_1937 world, class_2338 pos,
            class_1657 player,
            class_1268 hand,
            class_1799 stack,
            class_2680 state,
            class_3414 soundEvent
    ) {
        if (!world.method_8608()) {
            class_1792 item = stack.method_7909();
            if (!player.method_68878()) {
                stack.method_7934(1);
            }
            player.method_7281(class_3468.field_15430);
            player.method_7259(class_3468.field_15372.method_14956(item));
            world.method_8501(pos, state);
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, class_5712.field_28733, pos);
        }
        return class_1269.field_5812;
    }

    /**
     * Empties a cauldron if it's full.
     *
     * @param soundEvent the sound produced by emptying
     * @param output     the item stack that replaces the interaction stack when the cauldron is emptied
     * @param stack      the stack in the player's hand
     * @param player     the interacting player
     * @param pos        the cauldron's position
     * @param world      the world where the cauldron is located
     * @param state      the cauldron block state
     * @return a {@linkplain class_1269#method_23665 successful} action result if emptied, {@link class_1269#field_5811} otherwise
     */
    public static class_1269 emptyBlockFromCauldron(
            class_2680 state,
            class_1937 world, class_2338 pos,
            class_1657 player,
            class_1799 stack, class_1799 output,
            class_3414 soundEvent
    ) {
        if (!world.method_8608()) {
            if (state.method_28498(SandCauldronBlock.LEVEL) && state.method_11654(SandCauldronBlock.LEVEL) < SandCauldronBlock.MAX_LEVEL) {
                return class_1269.field_5814;
            }

            class_1792 item = stack.method_7909();

            class_1661 inventory = player.method_31548();
            if (!player.method_68878() || !inventory.method_7379(output)) {
                inventory.method_7394(output);
            }

            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956(item));
            world.method_8501(pos, class_2246.field_10593.method_9564());
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, class_5712.field_28733, pos);
        }
        return class_1269.field_5812;
    }

    private static class_5620 fillWithSand(class_2680 filledState) {
        return (state, world, pos, player, hand, stack) -> {
            return fillCauldronWithBlock(
                    world,
                    pos,
                    player,
                    hand,
                    stack,
                    filledState,
                    class_3417.field_15144
            );
        };
    }

    private SandCauldronBehaviours() {

    }
}
