package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.section.AccessibilitySettings;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_2718;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class ShaderStatusEffectManagers {

    private static final List<ShaderStatusEffectManager> TRACKED_MANAGERS = new ArrayList<>(2);

    private static final ShaderStatusEffectManager HEAT_STROKE = createAndTrack(
            Scorchful.id("heat_stroke"),
            SStatusEffects.HEAT_STROKE,
            AccessibilitySettings::enableHeatStrokePostProcessing
    );

    private static final ShaderStatusEffectManager FEAR = createAndTrack(
            Scorchful.id("fear"),
            SStatusEffects.FEAR,
            AccessibilitySettings::enableFearPostProcessing
    );

    public static void initialize() {
        ShaderStatusEffectManagers.getTrackedManagers().forEach(manager -> {
            ShaderEffectRenderCallback.EVENT.register(manager);
            ClientPlayConnectionEvents.DISCONNECT.register(manager);
        });
    }

    public static List<ShaderStatusEffectManager> getTrackedManagers() {
        return TRACKED_MANAGERS;
    }

    public static void onEffectAdded(class_2783 packet, class_638 world) {
        class_1297 entity = world.method_8469(packet.method_11943());
        if (entity instanceof class_746 player && player.method_7340()) {
            class_6880<class_1291> potionEffect = packet.method_11946();
            getTrackedManagers().forEach(manager -> manager.onEffectAdded(potionEffect));
        }
    }

    public static void onEffectRemoved(class_2718 packet, class_638 world) {
        class_1297 entity = packet.method_11767(world);
        if (entity instanceof class_746 player && player.method_7340()) {
            class_6880<class_1291> potionEffect = packet.comp_2176();
            getTrackedManagers().forEach(manager -> manager.onEffectRemoved(potionEffect));
        }
    }

    public static void onPlayerRespawn() {
        ShaderStatusEffectManagers.getTrackedManagers().forEach(ShaderStatusEffectManager::onPlayerRespawn);
    }

    public static ShaderStatusEffectManager createAndTrack(
            class_2960 shaderID,
            class_6880<class_1291> potionEffect,
            Predicate<AccessibilitySettings> enabledPredicate
    ) {
//        ManagedShaderEffect managedShaderEffect = ShaderEffectManager.getInstance().manage(shaderID);
        var statusEffectShader = new ShaderStatusEffectManager(
//                managedShaderEffect,
                shaderID,
                potionEffect,
                enabledPredicate
        );
        TRACKED_MANAGERS.add(statusEffectShader);
        return statusEffectShader;
    }

    private ShaderStatusEffectManagers() {

    }
}
