package com.github.thedeathlycow.scorchful.entity.feature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.entity.model.SunHatModel;
import com.github.thedeathlycow.scorchful.entity.state.SLivingEntityRenderState;
import com.github.thedeathlycow.scorchful.registry.SEntityModelLayers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_572;

@Environment(EnvType.CLIENT)
public class SunHatFeatureRenderer<S extends class_10034, M extends class_572<S>> extends class_3887<S, M> {

    private static final class_2960 TEXTURE = Scorchful.id("textures/entity/sun_hat.png");

    private final SunHatModel<S> model;
    private final SunHatModel<S> babyModel;

    public SunHatFeatureRenderer(
            class_3883<S, M> context,
            class_5599 modelLoader
    ) {
        super(context);
        this.model = new SunHatModel<>(modelLoader.method_32072(SEntityModelLayers.SUN_HAT));
        this.babyModel = new SunHatModel<>(modelLoader.method_32072(SEntityModelLayers.SUN_HAT_BABY));
    }

    @Override
    public void render(
            class_4587 matrices,
            class_11659 queue,
            int light,
            S state,
            float limbAngle,
            float limbDistance
    ) {
        if (((SLivingEntityRenderState) state).scorchful$hasSunHat()) {
            matrices.method_22903();

            M contextModel = this.method_17165();
            contextModel.method_63512().method_22703(matrices);

            queue.method_73529(1)
                    .method_73490(
                            this.model,
                            state,
                            matrices,
                            class_1921.method_25448(TEXTURE),
                            light,
                            class_4608.field_21444,
                            -1,
                            null,
                            state.field_61821,
                            null
                    );

            matrices.method_22909();
        }
    }
}
