package com.github.thedeathlycow.scorchful.item.component;

import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1799;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record HeatResistanceComponent(
        double heatResistance,
        double environmentHeatResistance
) {
    public static final Codec<HeatResistanceComponent> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.DOUBLE
                            .fieldOf("heat_resistance")
                            .forGetter(HeatResistanceComponent::heatResistance),
                    Codec.DOUBLE
                            .fieldOf("environment_heat_resistance")
                            .forGetter(HeatResistanceComponent::environmentHeatResistance)
            ).apply(instance, HeatResistanceComponent::new)
    );

    public static final class_9139<ByteBuf, HeatResistanceComponent> PACKET_CODEC = class_9139.method_56435(
            class_9135.field_48553,
            HeatResistanceComponent::heatResistance,
            class_9135.field_48553,
            HeatResistanceComponent::environmentHeatResistance,
            HeatResistanceComponent::new
    );

    public static final HeatResistanceComponent DEFAULT = new HeatResistanceComponent(-0.5, -0.125);
    public static final HeatResistanceComponent VERY_PROTECTIVE = new HeatResistanceComponent(1.0, 0.25);
    public static final HeatResistanceComponent PROTECTIVE = new HeatResistanceComponent(0.5, 0.125);
    public static final HeatResistanceComponent NEUTRAL = new HeatResistanceComponent(0, 0);
    public static final HeatResistanceComponent VERY_HARMFUL = new HeatResistanceComponent(-1, -0.25);

    public static HeatResistanceComponent get(class_1799 stack) {
        HeatResistanceComponent component = stack.method_58694(SDataComponentTypes.HEAT_RESISTANCE);
        return component != null ? component : byTag(stack);
    }

    public static HeatResistanceComponent byTag(class_1799 stack) {
        if (stack.method_31573(SItemTags.HEAT_RESISTANCE_MODIFIED)) {
            if (stack.method_31573(SItemTags.VERY_PROTECTIVE_HEAT_RESISTANCE)) {
                return VERY_PROTECTIVE;
            } else if (stack.method_31573(SItemTags.PROTECTIVE_HEAT_RESISTANCE)) {
                return PROTECTIVE;
            } else if (stack.method_31573(SItemTags.VERY_HARMFUL_HEAT_RESISTANCE)) {
                return VERY_HARMFUL;
            } else if (stack.method_31573(SItemTags.NEUTRAL_HEAT_RESISTANCE)) {
                return NEUTRAL;
            } else {
                return DEFAULT;
            }
        } else {
            return HeatResistanceComponent.NEUTRAL;
        }
    }
}