package com.github.thedeathlycow.scorchful.item.enchantment;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.ItemConfig;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.predicate.SoakedLootCondition;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.item.v1.EnchantmentSource;
import net.minecraft.class_1322;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2096;
import net.minecraft.class_5321;
import net.minecraft.class_9701;
import net.minecraft.class_9704;
import net.minecraft.class_9711;
import net.minecraft.class_9720;

public class EnchantmentModifiers {

    public static void initialize() {
        EnchantmentEvents.MODIFY.register(EnchantmentModifiers::modifyFireProtection);
        EnchantmentEvents.MODIFY.register(EnchantmentModifiers::modifyImpaling);
    }

    private static void modifyImpaling(class_5321<class_1887> key, class_1887.class_9700 builder, EnchantmentSource source) {
        if (!source.isBuiltin() || key != class_1893.field_9106) {
            return;
        }

        ItemConfig config = ScorchfulConfig.getItemConfig();

        builder.method_60067(
                class_9701.field_51661,
                new class_9711(class_9704.method_60194(config.getImpalingDamagePerLevel())),
                SoakedLootCondition.builder(class_2096.class_2100.method_9053(1))
                // TODO: registry lookup doesnt work, throws: java.lang.IllegalStateException: Missing tag TagKey[minecraft:entity_type / minecraft:sensitive_to_impaling]
//                AllOfLootCondition.builder(
//                        () -> new SoakedLootCondition(
//                                ,
//                                NumberRange.DoubleRange.ANY
//                        ),
//                        InvertedLootCondition.builder(
//                                EntityPropertiesLootCondition.builder(
//                                        LootContext.EntityTarget.THIS,
//                                        EntityPredicate.Builder.create()
//                                                .type(EntityTypePredicate.create(
//                                                        Registries.ENTITY_TYPE,
//                                                        EntityTypeTags.SENSITIVE_TO_IMPALING
//                                                ))
//                                )
//                        )
//                )
        );
    }

    private static void modifyFireProtection(class_5321<class_1887> key, class_1887.class_9700 builder, EnchantmentSource source) {
        if (!source.isBuiltin() || key != class_1893.field_9095) {
            return;
        }

        double valuePerLevel = ScorchfulConfig.getItemConfig().getFireProtectionHeatResistancePerLevel();
        builder.method_60065(
                class_9701.field_51668,
                new class_9720(
                        Scorchful.id("enchantment.fire_protection.heat_resistance"),
                        ThermooAttributes.HEAT_RESISTANCE,
                        class_9704.method_60194((float) valuePerLevel),
                        class_1322.class_1323.field_6328
                )
        );
    }

    private EnchantmentModifiers() {

    }
}
