package com.github.thedeathlycow.scorchful.mixin.compat.frostiful.absent;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class EntityMixin {

    @Shadow
    public abstract int getFrozenTicks();

    @Inject(
            method = "setFrozenTicks",
            at = @At("HEAD"),
            cancellable = true
    )
    private void cancelFrozenTicks(int frozenTicks, CallbackInfo ci) {
        class_1297 instance = (class_1297) (Object) this;
        if (frozenTicks > this.getFrozenTicks()
                && instance instanceof class_1309 livingEntity
                && livingEntity.thermoo$getTemperature() > 0) {
            ci.cancel();
        }
    }


}
