package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.particle.DustGrainParticleEffect;
import com.github.thedeathlycow.scorchful.particle.SpurtingWaterParticleEffect;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_7923;

public final class SParticleTypes {

    public static final class_2396<SpurtingWaterParticleEffect> SPURTING_WATER = register(
            "spurting_water",
            FabricParticleTypes.complex(
                    SpurtingWaterParticleEffect.CODEC,
                    SpurtingWaterParticleEffect.PACKET_CODEC
            )
    );

    public static final class_2396<DustGrainParticleEffect> DUST_GRAIN = register(
            "dust_grain",
            FabricParticleTypes.complex(
                    DustGrainParticleEffect.CODEC,
                    DustGrainParticleEffect.PACKET_CODEC
            )
    );

    public static final class_2400 BAT = registerSimple("bat", FabricParticleTypes.simple());

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful particle types");
    }

    private static <T extends class_2394> class_2396<T> register(String name, class_2396<T> particle) {
        return class_2378.method_10230(class_7923.field_41180, Scorchful.id(name), particle);
    }

    private static class_2400 registerSimple(String name, class_2400 particle) {
        return class_2378.method_10230(class_7923.field_41180, Scorchful.id(name), particle);
    }

    private SParticleTypes() {

    }

}
