package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.block.SandPileBlock;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.WeatherConfig;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5546;
import net.minecraft.class_5712;
import net.minecraft.class_5819;

public class SandAccumulation {
    public static void tickChunk(class_3218 world, class_2818 chunk, int randomTickSpeed) {
        // choose position
        final class_1923 chunkPos = chunk.method_12004();
        final class_2338 topPos = world.method_8598(
                class_2902.class_2903.field_13197,
                world.method_8536(chunkPos.method_8326(), 0, chunkPos.method_8328(), 15)
        );

        // control fail conditions
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm(world, topPos);
        if (sandstorm == Sandstorms.SandstormType.NONE) {
            return;
        }
        class_5819 random = world.field_9229;
        if (random.method_43048(16) != 0) {
            return;
        }

        // sand pile placement
        class_2248 sandPile = null;
        WeatherConfig config = ScorchfulConfig.getWeatherConfig();
        if (Objects.requireNonNull(sandstorm) == Sandstorms.SandstormType.REGULAR) {
            sandPile = SBlocks.SAND_PILE;
        } else if (sandstorm == Sandstorms.SandstormType.RED) {
            sandPile = SBlocks.RED_SAND_PILE;
        }
        if (sandPile != null) {
            placeSandPile(world, topPos, sandPile, config);
        }

        // cauldron tick
        class_2338 groundPos = topPos.method_10074();
        class_2680 groundState = world.method_8320(groundPos);
        class_2248 groundBlock = groundState.method_26204();
        if (groundBlock instanceof class_5546) {
            tickFillCauldron(world, groundPos);
        }
    }

    private static void tickFillCauldron(class_1937 world, class_2338 pos) {
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm(world, pos.method_10084());

        switch (sandstorm) {
            case REGULAR -> {
                world.method_8501(pos, SBlocks.SAND_CAULDRON.method_9564());
                world.method_33596(null, class_5712.field_28733, pos);
            }
            case RED -> {
                world.method_8501(pos, SBlocks.RED_SAND_CAULDRON.method_9564());
                world.method_33596(null, class_5712.field_28733, pos);
            }
            default -> {}
        }
    }

    private static void placeSandPile(class_3218 world, class_2338 topPos, class_2248 sandPileBlock, WeatherConfig config) {

        int accumulationHeight = config.getSandPileAccumulationHeight();
        if (!config.isSandPileAccumulationEnabled() || accumulationHeight <= 0) {
            return;
        }

        if (canSetSand(world, topPos, sandPileBlock)) {
            class_2680 sandPileState = sandPileBlock.method_9564();
            class_2680 currentState = world.method_8320(topPos);

            if (currentState.method_27852(sandPileBlock)) {
                int currentLayers = currentState.method_11654(SandPileBlock.LAYERS);

                if (currentLayers < Math.min(accumulationHeight, SandPileBlock.MAX_LAYERS)) {
                    sandPileState = currentState.method_11657(class_2488.field_11518, currentLayers + 1);
                    class_2248.method_9582(currentState, sandPileState, world, topPos);
                }

            }
            world.method_8501(topPos, sandPileState);
        }
    }

    private static boolean canSetSand(class_3218 world, class_2338 pos, class_2248 sandPileBlock) {
        class_2680 current = world.method_8320(pos);
        return pos.method_10264() >= world.method_31607()
                && pos.method_10264() < world.method_31600()
                && (current.method_26215() || current.method_27852(sandPileBlock))
                && sandPileBlock.method_9564().method_26184(world, pos);
    }

    private SandAccumulation() {

    }
}
