package com.github.thedeathlycow.scorchful.temperature.environment.provider;

import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9323;

public record CheckBiomeEnvironmentProvider(
        class_6885<class_1959> biomes,
        class_6885<class_1959> excludeBiomes,
        class_6880<EnvironmentProvider> provider
) implements EnvironmentProvider {
    public static final MapCodec<CheckBiomeEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_6895.method_40340(class_7924.field_41236)
                            .fieldOf("biomes")
                            .forGetter(CheckBiomeEnvironmentProvider::biomes),
                    class_6895.method_40340(class_7924.field_41236)
                            .fieldOf("exclude_biomes")
                            .forGetter(CheckBiomeEnvironmentProvider::excludeBiomes),
                    EnvironmentProvider.ENTRY_CODEC
                            .fieldOf("provider")
                            .forGetter(CheckBiomeEnvironmentProvider::provider)
            ).apply(instance, CheckBiomeEnvironmentProvider::new)
    );

    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        if (this.biomes.method_40241(biome) && !this.excludeBiomes.method_40241(biome)) {
            provider.comp_349().buildCurrentComponents(world, pos, biome, builder);
        }
    }

    @Override
    public EnvironmentProviderType<CheckBiomeEnvironmentProvider> getType() {
        return SEnvironmentProviderTypes.CHECK_BIOME;
    }
}