/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.ConfigUpdater;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV2;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV3;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV4;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV5;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV6;
import com.github.thedeathlycow.scorchful.config.schema.SchemaV7;
import com.github.thedeathlycow.scorchful.config.section.DehydrationConfig;
import com.github.thedeathlycow.scorchful.config.section.SchemaConfig;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;

class Updater {
    private static final Supplier<Int2ObjectMap<ConfigUpdater>> SCHEMAS = () -> {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        map.put(2, SchemaV2::run);
        map.put(3, SchemaV3::run);
        map.put(4, SchemaV4::run);
        map.put(5, SchemaV5::run);
        map.put(6, SchemaV6::run);
        map.put(7, SchemaV7::run);
        return map;
    };

    static void run() {
        boolean continueUpgrade;
        Path clothConfigPath = FabricLoader.getInstance().getConfigDir().resolve("scorchful.json");
        if (Files.exists(clothConfigPath, new LinkOption[0])) {
            try {
                Updater.updateToYACL(clothConfigPath);
                Scorchful.LOGGER.info("Scorchful config files successfully updated to YACL format");
            }
            catch (Exception e) {
                Scorchful.LOGGER.error("Unable to update config file to YACL", (Throwable)e);
            }
        }
        SchemaConfig.HANDLER.load();
        SchemaConfig schemaConfig = (SchemaConfig)SchemaConfig.HANDLER.instance();
        int latestSchemaVersion = 7;
        int currentSchemaVersion = schemaConfig.getSchemaVersion();
        if (currentSchemaVersion < 7) {
            Scorchful.LOGGER.info("Scorchful config is out of date! Config files will be automatically upgraded.");
            continueUpgrade = true;
        } else if (currentSchemaVersion > 7) {
            Scorchful.LOGGER.error("Current scorchful config schema version {} is greater than the latest supported by this version ({}). This may result in unexpected changes to the config files, are you sure you're using the right mod version?", (Object)currentSchemaVersion, (Object)7);
            continueUpgrade = false;
        } else {
            Scorchful.LOGGER.info("Scorchful config is up tp date!");
            continueUpgrade = false;
        }
        if (!continueUpgrade) {
            return;
        }
        Int2ObjectMap<ConfigUpdater> schemas = SCHEMAS.get();
        for (int step = currentSchemaVersion + 1; step <= 7; ++step) {
            ConfigUpdater updater = (ConfigUpdater)schemas.get(step);
            if (updater != null) {
                try {
                    updater.run(currentSchemaVersion);
                }
                catch (IOException e) {
                    Scorchful.LOGGER.warn("Unable to upgrade config file from schema version {} to {}, due to IO error. Aborting upgrade.", new Object[]{step - 1, step, e});
                    break;
                }
            }
            schemaConfig.setSchemaVersion(step);
        }
        SchemaConfig.HANDLER.save();
        Scorchful.LOGGER.info("Scorchful config successfully updated from schema version {} to {}.", (Object)currentSchemaVersion, (Object)7);
    }

    private static void updateToYACL(Path oldConfigPath) throws IOException {
        Scorchful.LOGGER.info("Attempting to update Scorchful config files to YACL");
        String content = Files.readString(oldConfigPath);
        JsonObject root = JsonParser.parseString((String)content).getAsJsonObject();
        JsonObject clientConfig = root.remove("clientConfig").getAsJsonObject();
        JsonObject heatingConfig = root.remove("heatingConfig").getAsJsonObject();
        JsonObject combatConfig = root.remove("combatConfig").getAsJsonObject();
        JsonObject weatherConfig = root.remove("weatherConfig").getAsJsonObject();
        JsonObject thirstConfig = root.remove("thirstConfig").getAsJsonObject();
        JsonObject dehydrationConfig = root.getAsJsonObject("integrationConfig").remove("dehydrationConfig").getAsJsonObject();
        boolean writeSchemaFile = Updater.copyOldConfigObject(clientConfig, SchemaV2.getOldClientConfigPath());
        writeSchemaFile &= Updater.copyOldConfigObject(combatConfig, SchemaV5.getCombatConfigPath());
        writeSchemaFile &= Updater.copyOldConfigObject(heatingConfig, SchemaV3.getHeatingConfigPath());
        writeSchemaFile &= Updater.copyOldConfigObject(weatherConfig, SchemaV6.getOldWeatherPath());
        writeSchemaFile &= Updater.copyOldConfigObject(thirstConfig, SchemaV5.getThirstConfigPath());
        if (writeSchemaFile &= Updater.copyOldConfigObject(dehydrationConfig, DehydrationConfig.PATH)) {
            JsonObject json = new JsonObject();
            json.addProperty("schemaVersion", (Number)1);
            Files.writeString(SchemaConfig.PATH, (CharSequence)json.toString(), StandardOpenOption.CREATE);
        }
        Files.delete(oldConfigPath);
    }

    private static boolean copyOldConfigObject(JsonObject json, Path dest) throws IOException {
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.writeString(dest, (CharSequence)json.toString(), StandardOpenOption.CREATE);
            return true;
        }
        Scorchful.LOGGER.warn("Config file {} already exists, skipping upgrade", (Object)dest);
        return false;
    }

    private Updater() {
    }
}

