/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public final class JsonCopyHelper {
    public static void moveInto(JsonObject src, JsonObject dest) {
        for (String key : src.deepCopy().keySet()) {
            dest.add(key, src.remove(key));
        }
    }

    public static void copyStringProperty(JsonObject src, JsonObject dest, String propertyName) {
        dest.addProperty(propertyName, src.remove(propertyName).getAsString());
    }

    public static void copyBooleanProperty(JsonObject src, JsonObject dest, String propertyName) {
        dest.addProperty(propertyName, Boolean.valueOf(src.remove(propertyName).getAsBoolean()));
    }

    public static void copyFloatProperty(JsonObject src, JsonObject dest, String propertyName) {
        dest.addProperty(propertyName, (Number)Float.valueOf(src.remove(propertyName).getAsFloat()));
    }

    public static void copyDoubleProperty(JsonObject src, JsonObject dest, String propertyName) {
        dest.addProperty(propertyName, (Number)src.remove(propertyName).getAsDouble());
    }

    public static void copyIntProperty(JsonObject src, JsonObject dest, String propertyName) {
        dest.addProperty(propertyName, (Number)src.remove(propertyName).getAsInt());
    }

    public static void convertIntToFloatMultiplier(JsonObject src, String name, int oldDefaultValue) {
        JsonCopyHelper.convertIntToFloatMultiplier(src, name, oldDefaultValue, 1.0f);
    }

    public static void normalizeFloat(JsonObject src, String name, float base) {
        float value = src.remove(name).getAsFloat();
        src.addProperty(name, (Number)Float.valueOf(value / base));
    }

    public static void convertIntToFloatMultiplier(JsonObject src, String name, int oldDefaultValue, float base) {
        int savedValue = Math.abs(src.remove(name).getAsInt());
        float multiplier = (float)savedValue / (float)oldDefaultValue;
        src.addProperty(name, (Number)Float.valueOf(multiplier * base));
    }

    public static void rename(JsonObject json, String oldName, String newName) {
        JsonElement prop = json.remove(oldName);
        json.add(newName, prop);
    }

    public static JsonObject read(Path path) throws IOException {
        return JsonParser.parseString((String)Files.readString(path)).getAsJsonObject();
    }

    private JsonCopyHelper() {
    }
}

