/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.JsonCopyHelper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public final class SchemaV2 {
    public static Path getOldClientConfigPath() {
        return Scorchful.getConfigDir().resolve("client.json5");
    }

    public static void run(int originalSchemaVersion) throws IOException {
        Path oldPath = SchemaV2.getOldClientConfigPath();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            Scorchful.LOGGER.warn("Removing client config from dedicated server, this did nothing anyway.");
            Files.delete(oldPath);
            return;
        }
        String content = Files.readString(oldPath);
        JsonObject oldClientConfig = JsonParser.parseString((String)content).getAsJsonObject();
        JsonObject accessibility = new JsonObject();
        JsonObject display = new JsonObject();
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, display, "doBurningHeartOverlay");
        JsonCopyHelper.rename(display, "doBurningHeartOverlay", "enableBurningHeartOverlay");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, display, "doSoakingOverlay");
        JsonCopyHelper.rename(display, "doSoakingOverlay", "enableSoakingOverlay");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, display, "enableWetDripParticles");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, accessibility, "enableSoundTemperatureEffects");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, accessibility, "enableHeatStrokePostProcessing");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, accessibility, "enableFearPostProcessing");
        JsonCopyHelper.copyBooleanProperty(oldClientConfig, accessibility, "doSunHatShading");
        JsonCopyHelper.rename(accessibility, "doSunHatShading", "enableSunHatShading");
        JsonCopyHelper.copyFloatProperty(oldClientConfig, accessibility, "sunHatShadeOpacity");
        Path basePath = Scorchful.getConfigDir().resolve("client");
        Files.createDirectories(basePath, new FileAttribute[0]);
        Path path = basePath.resolve("accessibility.json5");
        Files.writeString(path, (CharSequence)accessibility.toString(), new OpenOption[0]);
        path = basePath.resolve("display.json5");
        Files.writeString(path, (CharSequence)display.toString(), new OpenOption[0]);
        Files.delete(oldPath);
    }

    private SchemaV2() {
    }
}

