/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.JsonCopyHelper;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class SchemaV3 {
    public static Path getHeatingConfigPath() {
        return Scorchful.getConfigDir().resolve("heating.json5");
    }

    public static Path getThirstConfigPath() {
        return Scorchful.getConfigDir().resolve("thirst.json5");
    }

    public static void run(int originalSchemaVersion) throws IOException {
        JsonObject oldHeatingConfig = JsonCopyHelper.read(SchemaV3.getHeatingConfigPath());
        JsonObject oldThirstConfig = JsonCopyHelper.read(SchemaV3.getThirstConfigPath());
        JsonObject temperatureConfig = new JsonObject();
        temperatureConfig.addProperty("coolingMultiplier", (Number)Float.valueOf(1.0f));
        temperatureConfig.addProperty("heatingMultiplier", (Number)Float.valueOf(1.0f));
        temperatureConfig.addProperty("sweatEfficiency", (Number)Float.valueOf(1.0f));
        JsonCopyHelper.copyBooleanProperty(oldHeatingConfig, temperatureConfig, "doPassiveHeating");
        JsonCopyHelper.rename(temperatureConfig, "doPassiveHeating", "enableEnvironmentHeating");
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "passiveHeatingTickInterval");
        JsonCopyHelper.rename(temperatureConfig, "passiveHeatingTickInterval", "environmentHeatingTickInterval");
        JsonCopyHelper.copyFloatProperty(oldHeatingConfig, temperatureConfig, "maxPassiveHeatingScale");
        JsonCopyHelper.rename(temperatureConfig, "maxPassiveHeatingScale", "maxEnvironmentHeatingScale");
        JsonCopyHelper.copyDoubleProperty(oldHeatingConfig, temperatureConfig, "minTemperatureForHeatC");
        JsonCopyHelper.copyDoubleProperty(oldHeatingConfig, temperatureConfig, "degreesCPerTemperatureIncrease");
        JsonCopyHelper.copyFloatProperty(oldHeatingConfig, temperatureConfig, "environmentTemperatureMultiplier");
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "onFireWarmRate");
        JsonCopyHelper.rename(temperatureConfig, "onFireWarmRate", "burningTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "burningTemperatureMultiplier", 24);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "onFireWarmRateWithFireResistance");
        JsonCopyHelper.rename(temperatureConfig, "onFireWarmRateWithFireResistance", "burningTemperatureMultiplierWithFireResistance");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "burningTemperatureMultiplierWithFireResistance", 6, 0.25f);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "inLavaWarmRate");
        JsonCopyHelper.rename(temperatureConfig, "inLavaWarmRate", "inLavaTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "inLavaTemperatureMultiplier", 24);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "powderSnowCoolRate");
        JsonCopyHelper.rename(temperatureConfig, "powderSnowCoolRate", "powderSnowTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "powderSnowTemperatureMultiplier", 24);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "fireballHeat");
        JsonCopyHelper.rename(temperatureConfig, "fireballHeat", "fireballTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "fireballTemperatureMultiplier", 1000);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "coolingFromIce");
        JsonCopyHelper.rename(temperatureConfig, "coolingFromIce", "iceTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "iceTemperatureMultiplier", 12);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "temperatureFromCoolingFood");
        JsonCopyHelper.rename(temperatureConfig, "temperatureFromCoolingFood", "coolingFoodTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "coolingFoodTemperatureMultiplier", 1260);
        JsonCopyHelper.copyIntProperty(oldHeatingConfig, temperatureConfig, "striderOutOfLavaCoolRate");
        JsonCopyHelper.rename(temperatureConfig, "striderOutOfLavaCoolRate", "striderCoolingTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "striderCoolingTemperatureMultiplier", 24);
        JsonCopyHelper.copyIntProperty(oldThirstConfig, temperatureConfig, "temperatureFromWetness");
        JsonCopyHelper.rename(temperatureConfig, "temperatureFromWetness", "soakedTemperatureMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(temperatureConfig, "soakedTemperatureMultiplier", 6);
        JsonCopyHelper.copyFloatProperty(oldThirstConfig, temperatureConfig, "humidBiomeSweatEfficiency");
        JsonCopyHelper.rename(temperatureConfig, "humidBiomeSweatEfficiency", "humidBiomeSweatEfficiencyMultiplier");
        JsonCopyHelper.normalizeFloat(temperatureConfig, "humidBiomeSweatEfficiencyMultiplier", 0.33333334f);
        JsonCopyHelper.copyFloatProperty(oldThirstConfig, temperatureConfig, "extraHumidBiomeSweatEfficiency");
        JsonCopyHelper.rename(temperatureConfig, "extraHumidBiomeSweatEfficiency", "extraHumidBiomeSweatEfficiencyMultiplier");
        JsonCopyHelper.normalizeFloat(temperatureConfig, "extraHumidBiomeSweatEfficiencyMultiplier", 0.16666667f);
        JsonCopyHelper.copyFloatProperty(oldThirstConfig, temperatureConfig, "aridBiomeSweatEfficiency");
        JsonCopyHelper.rename(temperatureConfig, "aridBiomeSweatEfficiency", "aridBiomeSweatEfficiencyMultiplier");
        JsonCopyHelper.normalizeFloat(temperatureConfig, "aridBiomeSweatEfficiencyMultiplier", 1.5f);
        Path basePath = Scorchful.getConfigDir().resolve("common");
        Files.createDirectories(basePath, new FileAttribute[0]);
        Path path = basePath.resolve("temperature.json5");
        Files.writeString(path, (CharSequence)temperatureConfig.toString(), new OpenOption[0]);
        Files.writeString(SchemaV3.getHeatingConfigPath(), (CharSequence)oldHeatingConfig.toString(), new OpenOption[0]);
        Files.writeString(SchemaV3.getThirstConfigPath(), (CharSequence)oldThirstConfig.toString(), new OpenOption[0]);
    }

    private SchemaV3() {
    }
}

