/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.JsonCopyHelper;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class SchemaV5 {
    public static Path getCombatConfigPath() {
        return Scorchful.getConfigDir().resolve("combat.json5");
    }

    public static Path getThirstConfigPath() {
        return Scorchful.getConfigDir().resolve("thirst.json5");
    }

    public static void run(int originalSchemaVersion) throws IOException {
        JsonObject oldCombatConfig = JsonCopyHelper.read(SchemaV5.getCombatConfigPath());
        JsonObject oldThirstConfig = JsonCopyHelper.read(SchemaV5.getThirstConfigPath());
        JsonObject entityConfig = new JsonObject();
        JsonCopyHelper.moveInto(oldCombatConfig, entityConfig);
        JsonCopyHelper.moveInto(oldThirstConfig, entityConfig);
        JsonCopyHelper.rename(entityConfig, "soakingFromSplashPotions", "soakingFromSplashPotionsMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(entityConfig, "soakingFromSplashPotionsMultiplier", 300);
        JsonCopyHelper.rename(entityConfig, "onFireDryDate", "onFireDryRateMultiplier");
        JsonCopyHelper.convertIntToFloatMultiplier(entityConfig, "onFireDryRateMultiplier", 3);
        Path path = Scorchful.getConfigDir().resolve("common").resolve("entity.json5");
        Files.writeString(path, (CharSequence)entityConfig.toString(), new OpenOption[0]);
        Files.delete(SchemaV5.getCombatConfigPath());
        Files.delete(SchemaV5.getThirstConfigPath());
    }

    private SchemaV5() {
    }
}

