/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.schema;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.schema.JsonCopyHelper;
import com.github.thedeathlycow.scorchful.config.section.TemperatureConfig;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class SchemaV7 {
    public static Path getTemperatureConfigPath() {
        return TemperatureConfig.PATH;
    }

    public static void run(int originalSchemaVersion) throws IOException {
        if (originalSchemaVersion > 1 && originalSchemaVersion < 7) {
            Path path = SchemaV7.getTemperatureConfigPath();
            JsonObject temperatureConfig = JsonCopyHelper.read(path);
            temperatureConfig.addProperty("soakedTemperatureMultiplier", (Number)Float.valueOf(1.0f));
            temperatureConfig.addProperty("coolingFoodTemperatureMultiplier", (Number)Float.valueOf(1.0f));
            temperatureConfig.addProperty("humidBiomeSweatEfficiencyMultiplier", (Number)Float.valueOf(1.0f));
            temperatureConfig.addProperty("extraHumidBiomeSweatEfficiencyMultiplier", (Number)Float.valueOf(1.0f));
            temperatureConfig.addProperty("aridBiomeSweatEfficiencyMultiplier", (Number)Float.valueOf(1.0f));
            Files.writeString(SchemaV7.getTemperatureConfigPath(), (CharSequence)temperatureConfig.toString(), new OpenOption[0]);
            Scorchful.LOGGER.warn("A few options in Scorchful's Temperature Settings config were reset by Schema V7 to fix a bug in the auto update script. If you have modified the config, you may need to manually re-adjust these settings.");
        }
    }

    private SchemaV7() {
    }
}

