/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.IntSlider;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;

public class DehydrationConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("compat").resolve("dehydration.json5");
    public static final ConfigClassHandler<DehydrationConfig> HANDLER = ConfigClassHandler.createBuilder(DehydrationConfig.class).id(Scorchful.id("compat/dehydration")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    private static final String CATEGORY = "main";
    @AutoGen(category="main")
    @Translate.Name(value="Minimum water level required for sweating")
    @SerialEntry(comment="The minimum number of water points needed to be able to sweat (similar to how much hunger you need to heal)")
    @IntSlider(min=0, max=20, step=1)
    int minWaterLevelForSweat = 16;

    public float getDehydrationConsumedBySweat() {
        float pointRange = (20.0f - (float)this.minWaterLevelForSweat) * 4.0f;
        return pointRange / 300.0f;
    }

    public int getMinWaterLevelForSweat() {
        return this.minWaterLevelForSweat;
    }

    public int getMaxWaterLost() {
        return 20 - this.minWaterLevelForSweat;
    }

    public int getRehydrationDrinkSize() {
        return 300;
    }
}

