/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleField;
import dev.isxander.yacl3.config.v2.api.autogen.FloatField;
import dev.isxander.yacl3.config.v2.api.autogen.FloatSlider;
import dev.isxander.yacl3.config.v2.api.autogen.IntField;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;
import net.minecraft.class_3532;

public class TemperatureConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("common").resolve("temperature.json5");
    public static final ConfigClassHandler<TemperatureConfig> HANDLER = ConfigClassHandler.createBuilder(TemperatureConfig.class).id(Scorchful.id("common/temperature")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    public static final String GENERAL_CATEGORY_NAME = "general";
    public static final String ENVIRONMENT_CATEGORY_NAME = "environment";
    public static final String TEMPERATURE_SOURCES_CATEGORY_NAME = "temperature_sources";
    @AutoGen(category="general")
    @Translate.Name(value="Heating multiplier")
    @SerialEntry(comment="Multiplies the final temperature point change of all non-environment heating sources like fire and lava.")
    @FloatField(min=0.0f, format="%.2f")
    float heatingMultiplier = 1.0f;
    @AutoGen(category="general")
    @Translate.Name(value="Cooling multiplier")
    @SerialEntry(comment="Multiplies the final temperature point change of all non-environment cooling sources like sweating and powder snow.")
    @FloatField(min=0.0f, format="%.2f")
    float coolingMultiplier = 1.0f;
    @AutoGen(category="general")
    @Translate.Name(value="Environment temperature multiplier")
    @SerialEntry(comment="Multiplies the final temperature point change of an environment temperature change.")
    @FloatField(min=0.0f, format="%.2f")
    float environmentTemperatureMultiplier = 1.0f;
    @AutoGen(category="environment")
    @Translate.Name(value="Enable environment heating")
    @SerialEntry(comment="Global toggle on all heating from the environment.")
    @TickBox
    boolean enableEnvironmentHeating = true;
    @AutoGen(category="environment")
    @Translate.Name(value="Environment heating tick interval")
    @SerialEntry(comment="How many ticks should occur between applying heat to a player from the environment. Setting this to large values can be used to slow heat down. This may not be set to a value less than 1.")
    @IntField(min=1)
    int environmentHeatingTickInterval = 1;
    @AutoGen(category="environment")
    @Translate.Name(value="Max environment heating scale")
    @SerialEntry(comment="The maximum temperature scale that the environment can heat players to. Given as a percentage from 0 to 1 (0 = 0%, 1 = 100%)")
    @FloatSlider(min=0.0f, max=1.0f, step=0.05f, format="%.2f")
    float maxEnvironmentHeatingScale = 1.0f;
    @AutoGen(category="environment")
    @Translate.Name(value="Minimum temperature for heat (in \u00b0C)")
    @SerialEntry(comment="Cutoff temperature for overheating in Celsius. Biomes at or above this temperature will apply environment heating to players. May not be less than 25\u00b0C.")
    @DoubleField(min=25.0)
    double minTemperatureForHeatC = 30.0;
    @AutoGen(category="environment")
    @Translate.Name(value="Degrees per temperature level increase (in \u00b0C/\u00b0K)")
    @SerialEntry(comment="Specifies the number of Celsius/Kelvin degrees the temperature must be above the minimum heat threshold for each one-point increase in player temperature per tick. Must be positive and non-zero.")
    @DoubleField(min=0.01)
    double degreesCPerTemperatureIncrease = 10.0;
    @AutoGen(category="environment")
    @Translate.Name(value="Sweating efficiency")
    @SerialEntry(comment="A multiplier for overall sweating efficiency. Large values mean you will cool down faster from being wet.")
    @FloatSlider(min=0.0f, max=2.0f, step=0.05f, format="%.2f")
    float sweatEfficiency = 1.0f;
    @AutoGen(category="environment")
    @Translate.Name(value="Humid biome sweating efficiency multiplier")
    @SerialEntry(comment="A multiplier for sweating efficiency when the relative humidity is between 65% and 80^. This applies to rainy climates like Jungles, Swamps, etc.")
    @FloatSlider(min=0.0f, max=2.0f, step=0.05f, format="%.2f")
    float humidBiomeSweatEfficiencyMultiplier = 1.0f;
    @AutoGen(category="environment")
    @Translate.Name(value="Extra Humid biome sweating efficiency multiplier")
    @SerialEntry(comment="A multiplier for sweating efficiency when the relative humidity is at or above 80%. This applies to rainy climates like Jungles, Swamps during the Wet Season (if a seasons mod is installed); to cave biomes; and to all non-arid biomes when it rains.")
    @FloatSlider(min=0.0f, max=2.0f, step=0.05f, format="%.2f")
    float extraHumidBiomeSweatEfficiencyMultiplier = 1.0f;
    @AutoGen(category="environment")
    @Translate.Name(value="Arid biome sweating efficiency multiplier")
    @SerialEntry(comment="A multiplier for sweating efficiency when the relative humidity is at or below 20%. This applies to arid climates like Deserts, Badlands, and Savannas, as well as The Nether.")
    @FloatSlider(min=0.0f, max=2.0f, step=0.05f, format="%.2f")
    float aridBiomeSweatEfficiencyMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Fireball temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied to entities when struck by a Fire Charge.")
    @FloatField(min=0.0f, format="%.2f")
    float fireballTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Burning temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied to entities on fire each tick.")
    @FloatField(min=0.0f, format="%.2f")
    float burningTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Burning temperature multiplier with Fire Resistance")
    @SerialEntry(comment="Multiplies the temperature point change applied to entities that are on fire, but also have the Fire Resistance effect, each tick.")
    @FloatField(min=0.0f, format="%.2f")
    float burningTemperatureMultiplierWithFireResistance = 0.25f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="In lava warm rate temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied to entities swimming in Lava each tick.")
    @FloatField(min=0.0f, format="%.2f")
    float inLavaTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Soaked temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied entities that are wet, each tick.")
    @FloatField(min=0.0f, format="%.2f")
    float soakedTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Powder Snow temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied to entities in Powder Snow each tick. This only applies to entities that are currently warm.")
    @FloatField(min=0.0f, format="%.2f")
    float powderSnowTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Ice temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied each tick from entities standing on ice.")
    @FloatField(min=0.0f, format="%.2f")
    float iceTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Cooling food temperature multiplier")
    @SerialEntry(comment="Multiplies the temperature point change applied to players after eating items with the tag #scorchful:is_cooling_food.")
    @FloatField(min=0.0f, format="%.2f")
    float coolingFoodTemperatureMultiplier = 1.0f;
    @AutoGen(category="temperature_sources")
    @Translate.Name(value="Strider cooling temperature multiplier")
    @SerialEntry(comment="Multiplies the cooling to applied only to Striders each tick they are not in Lava.")
    @FloatField(min=0.0f, format="%.2f")
    float striderCoolingTemperatureMultiplier = 1.0f;

    public float getHeatingMultiplier() {
        return this.heatingMultiplier;
    }

    public float getCoolingMultiplier() {
        return this.coolingMultiplier;
    }

    public float getEnvironmentTemperatureMultiplier() {
        return this.environmentTemperatureMultiplier;
    }

    public boolean isEnableEnvironmentHeating() {
        return this.enableEnvironmentHeating && this.environmentTemperatureMultiplier > 0.0f;
    }

    public int getEnvironmentHeatingTickInterval() {
        return this.environmentHeatingTickInterval;
    }

    public float getMaxEnvironmentHeatingScale() {
        return this.maxEnvironmentHeatingScale;
    }

    public double getMinTemperatureForHeatC() {
        return this.minTemperatureForHeatC;
    }

    public double getDegreesCPerTemperatureIncrease() {
        return this.degreesCPerTemperatureIncrease;
    }

    public float getHumidBiomeSweatEfficiency() {
        return 0.33333334f * this.humidBiomeSweatEfficiencyMultiplier * this.sweatEfficiency;
    }

    public float getExtraHumidBiomeSweatEfficiency() {
        return 0.16666667f * this.extraHumidBiomeSweatEfficiencyMultiplier * this.sweatEfficiency;
    }

    public float getAridBiomeSweatEfficiency() {
        return 1.5f * this.aridBiomeSweatEfficiencyMultiplier * this.sweatEfficiency;
    }

    public int getFireballHeat() {
        return class_3532.method_15375((float)(1000.0f * this.fireballTemperatureMultiplier * this.getHeatingMultiplier()));
    }

    public int getOnFireWarmRate(boolean hasFireResistance) {
        float multiplier = hasFireResistance ? this.burningTemperatureMultiplierWithFireResistance : this.burningTemperatureMultiplier;
        return class_3532.method_15375((float)(24.0f * multiplier * this.getHeatingMultiplier()));
    }

    public int getInLavaWarmRate() {
        return class_3532.method_15375((float)(24.0f * this.inLavaTemperatureMultiplier * this.getHeatingMultiplier()));
    }

    public int getTemperatureFromWetness() {
        return class_3532.method_15375((float)(-6.0f * this.soakedTemperatureMultiplier * this.getCoolingMultiplier()));
    }

    public int getPowderSnowCooling() {
        return class_3532.method_15375((float)(-24.0f * this.powderSnowTemperatureMultiplier * this.getCoolingMultiplier()));
    }

    public int getIceCooling() {
        return class_3532.method_15375((float)(-12.0f * this.iceTemperatureMultiplier * this.getCoolingMultiplier()));
    }

    public int getFoodCooling() {
        return class_3532.method_15375((float)(-1260.0f * this.coolingFoodTemperatureMultiplier * this.getCoolingMultiplier()));
    }

    public int getStriderCooling() {
        return class_3532.method_15375((float)(-24.0f * this.striderCoolingTemperatureMultiplier * this.getCoolingMultiplier()));
    }
}

