package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.particle.SpurtingWaterParticleEffect;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.SStats;
import com.github.thedeathlycow.scorchful.registry.tag.SEntityTypeTags;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

@SuppressWarnings("deprecation")
public class CrimsonLilyBlock extends NetherLilyBlock {
    public CrimsonLilyBlock(NetherLilyBehaviour.NetherLilyBehaviourMap behaviorMap, class_2251 settings) {
        super(behaviorMap, settings);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (state.method_11654(WATER_SATURATION_LEVEL) != 3) {
            return;
        }
        if (!world.field_9236) {
            soakEntity(state, world, pos, entity);
        } else {
            createSplash(world, pos);
        }
    }

    private static void soakEntity(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        world.method_45447(
                null,
                pos,
                SSoundEvents.CRIMSON_LILY_SQUELCH,
                class_3419.field_15245
        );

        if (entity instanceof Soakable soakable) {
            soakable.thermoo$addWetTicks(soakable.thermoo$getMaxWetTicks());
        }

        if (entity instanceof class_1657 player) {
            player.method_7281(SStats.SOAKED_BY_CRIMSON_LILY);
        }

        if (entity.method_5864().method_20210(SEntityTypeTags.CRIMSON_LILY_HURTS)) {
            entity.method_5643(
                    world.method_48963().method_48830(),
                    10f
            );
            entity.method_5783(
                    class_3417.field_15222,
                    1f, 1f
            );
        }

        NetherLilyBlock.setWater(state, world, pos, 0);
    }

    private static void createSplash(class_1937 world, class_2338 pos) {
        class_5819 random = world.method_8409();
        class_243 center = pos.method_46558();

        for (int i = 0; i < 40; i++) {

            double x = center.field_1352 + (random.method_43058() / 3) - (1.0 / 6.0);
            double y = center.field_1351;
            double z = center.field_1350 + (random.method_43058() / 3) - (1.0 / 6.0);

            world.method_8406(
                    new SpurtingWaterParticleEffect(i),
                    x, y, z,
                    0, 0, 0
            );
        }
    }

}
