package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3558;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class RootedNyliumBlock extends class_2248 implements class_2256 {
    public static final MapCodec<RootedNyliumBlock> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            class_7923.field_41175.method_39673()
                                    .fieldOf("roots_plant_block")
                                    .forGetter(b -> b.rootsPlantBlock),
                            method_54096()
                    )
                    .apply(instance, RootedNyliumBlock::new)
    );

    private final class_2248 rootsPlantBlock;

    public RootedNyliumBlock(class_2248 rootPlantBlock, class_2251 settings) {
        super(settings);
        this.rootsPlantBlock = rootPlantBlock;
    }

    @Override
    protected MapCodec<RootedNyliumBlock> method_53969() {
        return field_46280;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!stayAlive(state, world, pos)) {
            world.method_8501(pos, SBlocks.ROOTED_NETHERRACK.method_9564());
        }
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return world.method_8320(pos.method_10084()).method_26215();
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        world.method_8501(pos.method_10084(), this.rootsPlantBlock.method_9564());
    }

    private static boolean stayAlive(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        class_2680 blockState = world.method_8320(blockPos);
        int i = class_3558.method_20049(world, state, pos, blockState, blockPos, class_2350.field_11036, blockState.method_26193(world, blockPos));
        return i < world.method_8315();
    }
}
