package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import org.ladysnake.satin.api.event.ShaderEffectRenderCallback;
import org.ladysnake.satin.api.managed.ManagedShaderEffect;

import java.util.function.Predicate;

public final class ShaderStatusEffectManager implements ShaderEffectRenderCallback, ClientPlayConnectionEvents.Disconnect {

    private final ManagedShaderEffect managedShaderEffect;

    private final class_6880<class_1291> potionEffect;

    private final Predicate<ClientConfig> enabledPredicate;

    private boolean enabled = false;

    public ShaderStatusEffectManager(
            ManagedShaderEffect managedShaderEffect,
            class_6880<class_1291> potionEffect,
            Predicate<ClientConfig> enabledPredicate
    ) {
        this.managedShaderEffect = managedShaderEffect;
        this.potionEffect = potionEffect;
        this.enabledPredicate = enabledPredicate;
    }

    public void onEffectAdded(class_6880<class_1291> addedEffect) {
        if (addedEffect == potionEffect && this.enabledPredicate.test(Scorchful.getConfig().clientConfig)) {
            enabled = true;
        }
    }

    public void onEffectRemoved(class_6880<class_1291> removedEffect) {
        if (removedEffect == potionEffect) {
            enabled = false;
        }
    }

    public void onPlayerRespawn() {
        enabled = false;
    }

    @Override
    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.enabled = false;
    }

    @Override
    public void renderShaderEffects(float tickDelta) {
        if (enabled) {
            this.managedShaderEffect.render(tickDelta);
        }
    }
}
