package com.github.thedeathlycow.scorchful.compat;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.block.SandCauldronBehaviours;
import com.github.thedeathlycow.scorchful.block.SandCauldronBlock;
import com.github.thedeathlycow.scorchful.block.SandPileBlock;
import com.github.thedeathlycow.scorchful.mixin.accessor.PointOfInterestTypeAccessor;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.github.thedeathlycow.scorchful.registry.SItems;
import com.github.thedeathlycow.scorchful.registry.SPointsOfInterest;
import com.github.thedeathlycow.scorchful.server.SandAccumulation;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import com.github.thedeathlycow.thermoo.impl.compat.init.DependentModInitializer;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.hibiscus.naturespirit.registration.NSMiscBlocks;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3417;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4158;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5620;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class NaturesSpiritPatch implements DependentModInitializer {
    @Override
    public void onInitialize() {
        class_2248 pinkSandPileBlock = SBlocks.register(
                "natures_spirit/pink_sand_pile",
                settings -> new SandPileBlock(
                        0xDAAF88,
                        settings
                                .method_31710(class_3620.field_33533)
                                .method_51368(class_2766.field_12643)
                                .method_9632(0.5f)
                                .method_51371()
                                .method_51370()
                                .method_26245((state, world, pos) -> state.method_11654(class_2488.field_11518) >= SandPileBlock.MAX_LAYERS)
                                .method_50012(class_3619.field_15971)
                ),
                class_4970.class_2251.method_9630(class_2246.field_10102)
        );

        class_2248 pinkSandCauldronBlock = SBlocks.register(
                "natures_spirit/pink_sand_cauldron",
                settings -> new SandCauldronBlock(
                        Sandstorms.SandstormType.PINK,
                        getPinkSandCauldronBehavior(),
                        settings
                ),
                class_4970.class_2251.method_9630(class_2246.field_10593)
        );

        class_1792 pinkSandPileItem = SItems.register(
                "natures_spirit/pink_sand_pile",
                settings -> new class_1747(pinkSandPileBlock, settings)
        );

        SandAccumulation.SAND_PILES.put(Sandstorms.SandstormType.PINK, pinkSandPileBlock);
        SandAccumulation.SAND_CAULDRONS.put(Sandstorms.SandstormType.PINK, pinkSandCauldronBlock);

        class_5321<class_1761> group = class_5321.method_29179(class_7924.field_44688, Scorchful.id("main"));
        ItemGroupEvents.modifyEntriesEvent(group).register(entries -> {
            entries.method_45420(pinkSandPileItem.method_7854());
        });

        class_5620.field_27775.comp_1982().put(
                NSMiscBlocks.PINK_SAND.method_8389(),
                SandCauldronBehaviours.fillWithSand(
                        pinkSandCauldronBlock.method_9564()
                                .method_11657(SandCauldronBlock.LEVEL, SandCauldronBlock.MAX_LEVEL)
                )
        );

        class_6880<class_4158> leatherWorkerPOI = class_7923.field_41128
                .method_40264(class_7477.field_39285)
                .orElseThrow();

        Set<class_2680> blockStates = new HashSet<>(pinkSandCauldronBlock.method_9595().method_11662());

        ((PointOfInterestTypeAccessor) (Object) leatherWorkerPOI.comp_349()).scorchful$setBlockStates(
                ImmutableSet.<class_2680>builder()
                        .addAll(leatherWorkerPOI.comp_349().comp_815())
                        .addAll(blockStates)
                        .build()
        );

        SPointsOfInterest.registerStates(leatherWorkerPOI, blockStates);
    }

    @Override
    public String[] getRequiredModIds() {
        return new String[]{ScorchfulIntegrations.NATURES_SPIRIT_ID};
    }

    private static class_5620.class_8821 getPinkSandCauldronBehavior() {
        class_5620.class_8821 map = class_5620.method_32206("scorchful_natures_spirit_pink_sand_cauldron");

        if (map.comp_1982() instanceof Object2ObjectOpenHashMap<class_1792, class_5620> openHashMap) {
            openHashMap.defaultReturnValue((state, world, pos, player, hand, stack) -> {
                return SandCauldronBehaviours.emptyBlockFromCauldron(
                        state,
                        world,
                        pos,
                        player,
                        stack,
                        NSMiscBlocks.PINK_SAND.method_8389().method_7854(),
                        class_3417.field_15144
                );
            });
        } else {
            Scorchful.LOGGER.error("Unable to register default red sand cauldron behaviour");
        }

        return map;
    }
}