package com.github.thedeathlycow.scorchful.components;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.event.HeatVisionActivation;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.temperature.heatvision.HeatVision;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class EntityDesertVisionComponent implements Component, AutoSyncedComponent, ServerTickingComponent {


    private final class_1297 provider;

    @Nullable
    private class_1657 cause;

    @Nullable
    private HeatVision vision;

    private int timeToLive = 30 * 20;

    public EntityDesertVisionComponent(class_1297 provider) {
        this.provider = provider;
    }

    public boolean hasDesertVision() {
        return this.cause != null;
    }

    public void applyDesertVision(@NotNull HeatVision vision, @NotNull class_1657 cause) {
        this.cause = cause;
        this.vision = vision;
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        // visions should be transient, so not saved to NBT
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        // visions should be transient, so not saved to NBT
    }

    @Override
    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.method_37435(Optional.ofNullable(cause), (pBuf, player) -> pBuf.method_10797(player.method_5667()));

        Scorchful.LOGGER.debug("Writing sync packet to entity desert vision");
    }

    @Override
    public void applySyncPacket(class_9129 buf) {
        UUID uuid = buf.method_37436(class_9129::method_56344).orElse(null);

        this.cause = uuid != null
                ? this.provider.method_37908().method_18470(uuid)
                : null;

        Scorchful.LOGGER.debug("Applying sync packet to entity desert vision");
    }

    @Override
    public void serverTick() {
        if (!this.tickCanLive()) {
            Scorchful.LOGGER.debug("Discarding entity desert vision " + this.provider);
            this.provider.method_31472();
        }
    }

    public class_1657 getCause() {
        return cause;
    }

    private boolean tickCanLive() {
        if (this.cause == null) {
            return true;
        } else if (this.timeToLive-- <= 0) {
            return false;
        } else {
            double activationDistance = HeatVision.ACTIVATION_DISTANCE * HeatVision.ACTIVATION_DISTANCE;
            if (this.provider.method_5858(cause) < activationDistance) {
                HeatVisionActivation.EVENT.invoker().onActivated(
                        this.vision,
                        (class_3218) this.provider.method_37908(),
                        this.provider.method_24515(),
                        cause
                );
                return false;
            }
            return cause.method_6059(SStatusEffects.HEAT_STROKE);
        }
    }
}
