package com.github.thedeathlycow.scorchful.entity.feature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.entity.model.SunHatModel;
import com.github.thedeathlycow.scorchful.item.SunHatItem;
import com.github.thedeathlycow.scorchful.registry.SItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;

@Environment(EnvType.CLIENT)
public class SunHatFeatureRenderer<T extends class_1309, M extends class_572<T>> extends class_3887<T, M> {

    private static final class_2960 TEXTURE = Scorchful.id("textures/entity/sun_hat.png");

    private final SunHatModel<T> model;

    public SunHatFeatureRenderer(class_3883<T, M> context, SunHatModel<T> model) {
        super(context);
        this.model = model;
    }

    @Override
    public void render(
            class_4587 matrices, class_4597 vertexConsumers,
            int light,
            T entity,
            float limbAngle, float limbDistance,
            float tickDelta, float animationProgress,
            float headYaw, float headPitch
    ) {
        if (SunHatItem.isWearingSunHat(entity)) {
            this.method_17165().method_2818(this.model);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448(TEXTURE));
            this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 0xffffffff);
        }
    }
}
