package com.github.thedeathlycow.scorchful.hud;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import com.github.thedeathlycow.scorchful.item.SunHatItem;
import com.github.thedeathlycow.scorchful.registry.SItems;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class ShadeOverlay {

    public static final class_2960 SHADE_OVERLAY = Scorchful.id("textures/misc/shade_overlay.png");

    public static void renderShadeOverlay(
            class_332 context,
            @Nullable class_746 player,
            BiConsumer<class_332, Float> renderCallback
    ) {
        if (player != null && !player.method_31550() && SunHatItem.isWearingSunHat(player)) {
            ClientConfig config = Scorchful.getConfig().clientConfig;
            if (config.isSunHatShading()) {
                renderCallback.accept(context, config.getSunHatShadeOpacity());
            }
        }
    }

    private ShadeOverlay() {

    }

}
