package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.components.PlayerWaterComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;

public abstract class DrinkItem extends class_1792 {

    public static final int DRINK_TIME_TICKS = 32;
    private static final int START_DRINK_PARTICLES = DRINK_TIME_TICKS - 10;

    public DrinkItem(class_1793 settings) {
        super(settings);
    }

    protected abstract class_1799 getPostConsumeStack(class_1799 stack, class_1937 world, class_3222 serverPlayer);

    @Override
    public class_1799 method_7854() {
        var itemStack = super.method_7854();
        itemStack.method_57379(SDataComponentTypes.DRINK_LEVEL, DrinkLevelComponent.HYDRATING);
        return itemStack;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282(world, user, hand);
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (world.field_9236 && remainingUseTicks < START_DRINK_PARTICLES) {
            spawnWaterParticles(world, user, 2);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        user.method_32876(class_5712.field_28734);

        if (user instanceof class_3222 serverPlayer) {
            class_174.field_1198.method_8821(serverPlayer, stack);
            serverPlayer.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
            return this.getPostConsumeStack(super.method_7861(stack, world, user), world, serverPlayer);
        } else {
            return super.method_7861(stack, world, user);
        }
    }

    /**
     * Called from {@link com.github.thedeathlycow.scorchful.event.ScorchfulItemEvents#CONSUME_ITEM}. Applies water from drinking to the user.
     *
     * @param stack  Stack being consumed
     * @param player Player consuming the drink
     */
    public static void applyWater(class_1799 stack, class_3222 player) {
        if (ServerThirstPlugin.isCustomPluginLoaded()) {
            return;
        }

        DrinkLevelComponent drink = stack.method_57824(SDataComponentTypes.DRINK_LEVEL);
        if (drink == null) {
            return;
        }

        PlayerWaterComponent component = ScorchfulComponents.PLAYER_WATER.get(player);

        int water = drink.getDrinkingWater(Scorchful.getConfig().thirstConfig);
        component.drink(water);

        if (component.getWaterDrunk() >= PlayerWaterComponent.MAX_WATER * 0.9) {
            player.method_5783(SSoundEvents.ENTITY_GULP, 1f, 1f);
        }
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return DRINK_TIME_TICKS;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    private static void spawnWaterParticles(class_1937 world, class_1309 entity, int count) {
        class_5819 random = entity.method_59922();

        for (int i = 0; i < count; i++) {

            var velocity = new class_243((random.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 1, 0);
            velocity = velocity.method_1037(-entity.method_36455() * (class_3532.field_29844 / 180f));
            velocity = velocity.method_1024(-entity.method_36454() * (class_3532.field_29844 / 180f));

            double y = -random.method_43057() * 0.6 - 0.3;
            var postion = new class_243((random.method_43057() - 0.5) * 0.3, y, 0.6);
            postion = postion.method_1037(-entity.method_36455() * (class_3532.field_29844 / 180f));
            postion = postion.method_1024(-entity.method_36454() * (class_3532.field_29844 / 180f));
            postion = postion.method_1031(entity.method_23317(), entity.method_23320(), entity.method_23321());

            world.method_8406(
                    class_2398.field_11202,
                    postion.field_1352, postion.field_1351, postion.field_1350,
                    velocity.field_1352, velocity.field_1351 + 1, velocity.field_1350
            );
        }
    }
}
