package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3855;
import net.minecraft.class_6088;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireChargeThrower implements UseItemCallback {

    private static final int FIRE_CHARGE_COOL_DOWN = 20;

    @Override
    public class_1271<class_1799> interact(class_1657 player, class_1937 world, class_1268 hand) {
        if (player.method_7325()) {
            return class_1271.method_22430(class_1799.field_8037);
        }

        ScorchfulConfig config = Scorchful.getConfig();
        FireballFactory throwingTypes = config.combatConfig.getFireBallThrownType();

        class_1799 stack = player.method_5998(hand);
        if (!stack.method_31574(class_1802.field_8814) || throwingTypes == FireballFactory.DISABLED) {
            return class_1271.method_22430(class_1799.field_8037);
        }
        if (player.method_7357().method_7904(stack.method_7909())) {
            return class_1271.method_22431(stack);
        }

        // spawn fire charge entity
        if (!world.field_9236) {
            class_243 rotation = player.method_5720();
            class_3855 fireball = throwingTypes.create(world, player, rotation);

            if (fireball == null) {
                return class_1271.method_22430(class_1799.field_8037);
            }

            fireball.method_5814(fireball.method_23317(), player.method_23323(0.5) + 0.5, fireball.method_23321());
            fireball.method_16936(stack);
            world.method_8649(fireball);
            world.method_8444(null, class_6088.field_31176, player.method_24515(), 0);
        }

        // decrement stack
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        player.method_7357().method_7906(stack.method_7909(), FIRE_CHARGE_COOL_DOWN);

        return class_1271.method_22427(stack);
    }

    public enum FireballFactory {

        DISABLED {
            @Override
            @Nullable
            public class_3855 create(class_1937 world, class_1657 player, class_243 velocity) {
                return null;
            }
        },
        SMALL {
            @Override
            @NotNull
            public class_3855 create(class_1937 world, class_1657 player, class_243 velocity) {
                return new class_1677(
                        world, player,
                        velocity
                );
            }
        },
        LARGE {
            @Override
            @NotNull
            public class_3855 create(class_1937 world, class_1657 player, class_243 velocity) {
                return new class_1674(
                        world, player,
                        velocity, 1
                );
            }
        };

        @Nullable
        public abstract class_3855 create(class_1937 world, class_1657 player, class_243 velocity);

    }

}
