package com.github.thedeathlycow.scorchful.item.component;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.event.ScorchfulItemEvents;
import com.github.thedeathlycow.scorchful.item.TurtleArmorEffects;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.tag.SArmorMaterialTags;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialTags;
import com.github.thedeathlycow.thermoo.api.item.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import javax.xml.crypto.Data;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class HeatResistanceModifier {
    private static final Map<class_1304, class_2960> SLOT_IDS = new EnumMap<>(class_1304.class);
    private static final Map<class_1304, class_2960> ENVIRONMENT_SLOT_IDS = new EnumMap<>(class_1304.class);

    public static void initialize() {
        initializeLegacyMaterialTags();
        modifyVanillaItemComponents();
        initializeItemModifiers();
    }

    private static void initializeLegacyMaterialTags() {
        ScorchfulItemEvents.GET_DEFAULT_STACK.register(stack -> {
            if (!stack.method_57826(SDataComponentTypes.HEAT_RESISTANCE) && stack.method_7909() instanceof class_1738 armor) {
                class_6880<class_1741> material = armor.method_7686();
                if (material.method_40220(ArmorMaterialTags.VERY_RESISTANT_TO_HEAT)) {
                    stack.method_57379(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_PROTECTIVE);
                } else if (material.method_40220(ArmorMaterialTags.RESISTANT_TO_HEAT)) {
                    stack.method_57379(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.PROTECTIVE);
                } else if (material.method_40220(ArmorMaterialTags.VERY_WEAK_TO_HEAT)) {
                    stack.method_57379(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_HARMFUL);
                } else if (material.method_40220(SArmorMaterialTags.HEAT_NEUTRAL)) {
                    stack.method_57379(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.NEUTRAL);
                } else if (material.method_40220(ArmorMaterialTags.WEAK_TO_HEAT)) {
                    stack.method_57379(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.DEFAULT);
                }
            }
        });
    }

    private static void modifyVanillaItemComponents() {
        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    class_1802.field_47831,
                    builder -> {
                        class_9285 attributes = builder.getOrDefault(
                                class_9334.field_49636,
                                class_9285.field_49326
                        );

                        if (attributes.comp_2393().isEmpty()) {
                            attributes = class_1802.field_47831.method_7844();
                        }

                        attributes = attributes.method_57484(
                                ThermooAttributes.HEAT_RESISTANCE,
                                new class_1322(
                                        Scorchful.id("base_heat_resistance"),
                                        8.0,
                                        class_1322.class_1323.field_6328
                                ),
                                class_9274.field_50127
                        );

                        builder.method_57840(class_9334.field_49636, attributes);
                        builder.method_57840(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.NEUTRAL);
                    }
            );
        });

        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    List.of(
                            class_1802.field_8862,
                            class_1802.field_8678,
                            class_1802.field_8416,
                            class_1802.field_8753,
                            class_1802.field_8283,
                            class_1802.field_8873,
                            class_1802.field_8218,
                            class_1802.field_8313
                    ),
                    (builder, item) -> {
                        builder.method_57840(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.NEUTRAL);
                    }
            );
        });

        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    List.of(
                            class_1802.field_22027,
                            class_1802.field_22028,
                            class_1802.field_22029,
                            class_1802.field_22030
                    ),
                    (builder, item) -> {
                        builder.method_57840(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.PROTECTIVE);
                    }
            );
        });

        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    class_1802.field_8090,
                    builder -> {
                        builder.method_57840(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_PROTECTIVE);
                    }
            );
        });
    }

    private static void initializeItemModifiers() {
        ModifyItemAttributeModifiersCallback.EVENT.register(
                (stack, builder) -> {
                    if (stack.method_7909() instanceof class_1738 armor) {
                        HeatResistanceComponent resistance = HeatResistanceComponent.get(stack);

                        class_1304 slot = armor.method_7685();
                        class_9274 modifierSlot = class_9274.method_59524(slot);

                        if (resistance.heatResistance() != 0) {
                            builder.method_57487(
                                    ThermooAttributes.HEAT_RESISTANCE,
                                    new class_1322(
                                            SLOT_IDS.computeIfAbsent(slot, sl -> Scorchful.id("base_heat_resistance/" + sl.method_15434())),
                                            resistance.heatResistance(),
                                            class_1322.class_1323.field_6328
                                    ),
                                    modifierSlot
                            );
                        }

                        if (resistance.environmentHeatResistance() != 0) {
                            builder.method_57487(
                                    ThermooAttributes.ENVIRONMENT_HEAT_RESISTANCE,
                                    new class_1322(
                                            ENVIRONMENT_SLOT_IDS.computeIfAbsent(slot, sl -> Scorchful.id("base_environment_heat_resistance/" + sl.method_15434())),
                                            resistance.environmentHeatResistance(),
                                            class_1322.class_1323.field_6328
                                    ),
                                    modifierSlot
                            );
                        }
                    }
                }
        );
    }

    private HeatResistanceModifier() {

    }
}