package com.github.thedeathlycow.scorchful.mixin;

import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import net.minecraft.class_1297;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public class EntityMixin {

    @Inject(
            method = "shouldSave",
            at = @At("HEAD"),
            cancellable = true
    )
    private void cancelSaveIfDesertVisionChild(CallbackInfoReturnable<Boolean> cir) {
        class_1297 instance = (class_1297) (Object) this;
        if (ScorchfulComponents.ENTITY_DESERT_VISION.get(instance).hasDesertVision()) {
            cir.setReturnValue(false);
        }
    }

}
