package com.github.thedeathlycow.scorchful.mixin;

import com.github.thedeathlycow.scorchful.item.TurtleArmorEffects;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.temperature.heatvision.VisionSpawner;
import net.minecraft.class_1657;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public class PlayerEntityMixin {

    @Inject(
            method = "updateTurtleHelmet",
            at = @At("HEAD"),
            cancellable = true
    )
    private void scorchfulTurtleArmorUpdate(CallbackInfo ci) {
        TurtleArmorEffects.update((class_1657) (Object) this);
        ci.cancel();
    }

    @Inject(
            method = "tick",
            at = @At("TAIL")
    )
    private void afterTick(CallbackInfo ci) {
        VisionSpawner.tick((class_1657) (Object) this);
    }

    @Inject(
            method = "createPlayerAttributes",
            at = @At("TAIL")
    )
    private static void appendAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        class_5132.class_5133 builder = cir.getReturnValue();
        builder.method_26867(SEntityAttributes.REHYDRATION_EFFICIENCY);
    }

}
