package com.github.thedeathlycow.scorchful.particle;

import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9679;
import org.joml.Vector3f;

public class DustGrainParticleEffect extends class_9679 {

    public static final MapCodec<DustGrainParticleEffect> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            class_5699.field_40723
                                    .fieldOf("color")
                                    .forGetter(DustGrainParticleEffect::getColor),
                            field_51496
                                    .fieldOf("scale")
                                    .forGetter(DustGrainParticleEffect::method_59846)
                    )
                    .apply(instance, DustGrainParticleEffect::new)
    );
    public static final class_9139<class_9129, DustGrainParticleEffect> PACKET_CODEC = class_9139.method_56435(
            class_9135.field_48558,
            DustGrainParticleEffect::getColor,
            class_9135.field_48552,
            DustGrainParticleEffect::method_59846,
            DustGrainParticleEffect::new
    );

    private final Vector3f color;

    public DustGrainParticleEffect(Vector3f color, float scale) {
        super(scale);
        this.color = color;
    }

    @Override
    public class_2396<DustGrainParticleEffect> method_10295() {
        return SParticleTypes.DUST_GRAIN;
    }

    public Vector3f getColor() {
        return color;
    }
}
