package com.github.thedeathlycow.scorchful.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

public class SpurtingWaterParticle extends class_4003 {

    private static final float STARTING_Y_SPEED = 30f;

    private final int delay;

    protected SpurtingWaterParticle(
            class_638 clientWorld,
            double x, double y, double z,
            double velocityX, double velocityY, double velocityZ,
            int delay
    ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.field_3844 = 0.75f;
        this.field_3847 += delay;
        this.delay = delay;
    }

    @Override
    public void method_3070() {
        super.method_3070();

        if (this.field_3866 == delay) {
            this.field_3869 = STARTING_Y_SPEED;
        }
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<SpurtingWaterParticleEffect> {

        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        @Override
        public class_703 createParticle(
                SpurtingWaterParticleEffect parameters,
                class_638 world,
                double x, double y, double z,
                double velocityX, double velocityY, double velocityZ
        ) {
            var particle = new SpurtingWaterParticle(
                    world,
                    x, y, z,
                    velocityX, velocityY, velocityZ,
                    parameters.getDelay()
            );
            particle.method_18140(this.spriteProvider);
            particle.method_3084(0.2f, 0.3f, 1.0f);
            return particle;
        }
    }
}
