package com.github.thedeathlycow.scorchful.particle;

import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SpurtingWaterParticleEffect implements class_2394 {

    public static final MapCodec<SpurtingWaterParticleEffect> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            class_5699.field_33441
                                    .fieldOf("delay")
                                    .forGetter(SpurtingWaterParticleEffect::getDelay)
                    )
                    .apply(instance, SpurtingWaterParticleEffect::new)
    );
    public static final class_9139<class_9129, SpurtingWaterParticleEffect> PACKET_CODEC = class_9139.method_56434(
            class_9135.field_48550,
            SpurtingWaterParticleEffect::getDelay,
            SpurtingWaterParticleEffect::new
    );

    private final int delay;

    public SpurtingWaterParticleEffect(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return delay;
    }

    @Override
    public class_2396<SpurtingWaterParticleEffect> method_10295() {
        return SParticleTypes.SPURTING_WATER;
    }

}
