package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SArmorMaterials {

    public static final class_6880<class_1741> STRAW = register(
            "straw",
            class_156.method_654(
                    new EnumMap<>(class_1738.class_8051.class),
                    map -> {
                        map.put(class_1738.class_8051.field_41937, 1);
                        map.put(class_1738.class_8051.field_41936, 1);
                        map.put(class_1738.class_8051.field_41935, 1);
                        map.put(class_1738.class_8051.field_41934, 1);
                    }
            ),
            9,
            class_3417.field_14581,
            0.0f,
            0.0f,
            () -> class_1856.method_8091(class_1802.field_8861)
    );

    public static final class_6880<class_1741> TURTLE = register(
            "turtle",
            class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
                map.put(class_1738.class_8051.field_41937, 2);
                map.put(class_1738.class_8051.field_41936, 5);
                map.put(class_1738.class_8051.field_41935, 6);
                map.put(class_1738.class_8051.field_41934, 2);
                map.put(class_1738.class_8051.field_48838, 5);
            }),
            9,
            class_3417.field_14684,
            0.0F,
            0.0F,
            () -> class_1856.method_8091(class_1802.field_8161)
    );

    public static void initialize() {
        // load this class
    }


    private static class_6880<class_1741> register(
            String id,
            EnumMap<class_1738.class_8051, Integer> defense,
            int enchantability,
            class_6880<class_3414> equipSound,
            float toughness,
            float knockbackResistance,
            Supplier<class_1856> repairIngredient
    ) {
        List<class_1741.class_9196> list = List.of(new class_1741.class_9196(Scorchful.id(id)));
        return register(id, defense, enchantability, equipSound, toughness, knockbackResistance, repairIngredient, list);
    }

    private static class_6880<class_1741> register(
            String id,
            EnumMap<class_1738.class_8051, Integer> defense,
            int enchantability,
            class_6880<class_3414> equipSound,
            float toughness,
            float knockbackResistance,
            Supplier<class_1856> repairIngredient,
            List<class_1741.class_9196> layers
    ) {
        EnumMap<class_1738.class_8051, Integer> enumMap = new EnumMap<>(class_1738.class_8051.class);

        for (class_1738.class_8051 type : class_1738.class_8051.values()) {
            enumMap.put(type, defense.get(type));
        }

        return class_2378.method_47985(
                class_7923.field_48976,
                Scorchful.id(id),
                new class_1741(
                        enumMap,
                        enchantability,
                        equipSound,
                        repairIngredient,
                        layers,
                        toughness,
                        knockbackResistance
                )
        );
    }

}
