package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.item.component.HeatResistanceComponent;
import java.util.function.UnaryOperator;
import net.minecraft.class_2378;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9331;

public class SDataComponentTypes {

    public static final class_9331<DrinkLevelComponent> DRINK_LEVEL = register(
            "drink_level",
            builder -> builder
                    .method_57881(DrinkLevelComponent.CODEC)
                    .method_57882(DrinkLevelComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static final class_9331<Integer> NUM_DRINKS = register(
            "num_drinks",
            builder -> builder
                    .method_57881(class_5699.method_48766(0, WaterSkinItem.MAX_DRINKS))
                    .method_57882(class_9135.field_48550)
    );

    public static final class_9331<HeatResistanceComponent> HEAT_RESISTANCE = register(
            "heat_resistance",
            builder -> builder
                    .method_57881(HeatResistanceComponent.CODEC)
                    .method_57882(HeatResistanceComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful item components");
    }

    private static <T> class_9331<T> register(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(
                class_7923.field_49658,
                Scorchful.id(id),
                builderOperator.apply(class_9331.method_57873()).method_57880()
        );
    }

    private SDataComponentTypes() {

    }
}
