package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.block.SandPileBlock;
import com.github.thedeathlycow.scorchful.config.WeatherConfig;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.google.common.base.Suppliers;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_5819;

public class SandAccumulation {
    public static final Map<Sandstorms.SandstormType, class_2248> SAND_PILES = class_156.method_656(
            () -> {
                Map<Sandstorms.SandstormType, class_2248> map = new EnumMap<>(Sandstorms.SandstormType.class);
                map.put(Sandstorms.SandstormType.REGULAR, SBlocks.SAND_PILE);
                map.put(Sandstorms.SandstormType.RED, SBlocks.RED_SAND_PILE);
                return map;
            }
    );

    public static final Map<Sandstorms.SandstormType, class_2248> SAND_CAULDRONS = class_156.method_656(
            () -> {
                Map<Sandstorms.SandstormType, class_2248> map = new EnumMap<>(Sandstorms.SandstormType.class);
                map.put(Sandstorms.SandstormType.REGULAR, SBlocks.SAND_CAULDRON);
                map.put(Sandstorms.SandstormType.RED, SBlocks.RED_SAND_CAULDRON);
                return map;
            }
    );

    public static void tickChunk(class_3218 world, class_2818 chunk, int randomTickSpeed) {
        // choose position
        final class_1923 chunkPos = chunk.method_12004();
        final class_2338 topPos = world.method_8598(
                class_2902.class_2903.field_13197,
                world.method_8536(chunkPos.method_8326(), 0, chunkPos.method_8328(), 15)
        );

        // control fail conditions
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm(world, topPos);
        if (sandstorm == Sandstorms.SandstormType.NONE) {
            return;
        }
        class_5819 random = world.field_9229;
        if (random.method_43048(16) != 0) {
            return;
        }

        // sand pile placement
        class_2248 sandPile = SAND_PILES.get(sandstorm);
        if (sandPile == null) {
            return;
        }

        WeatherConfig config = Scorchful.getConfig().weatherConfig;

        placeSandPile(world, topPos, sandPile, config);

        // cauldron tick
        class_2338 groundPos = topPos.method_10074();
        class_2680 groundState = world.method_8320(groundPos);
        class_2248 groundBlock = groundState.method_26204();
        groundBlock.method_9504(groundState, world, groundPos, class_1959.class_1963.field_9384);
    }

    public static boolean cauldronSandstormTick(class_2680 state, class_1937 world, class_2338 pos) {
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm(world, pos.method_10084());

        class_2248 cauldron = SAND_CAULDRONS.get(sandstorm);

        if (cauldron != null) {
            world.method_8501(pos, cauldron.method_9564());
            world.method_33596(null, class_5712.field_28733, pos);
            return true;
        }

        return false;
    }

    private static void placeSandPile(class_3218 world, class_2338 topPos, class_2248 sandPileBlock, WeatherConfig config) {

        int accumulationHeight = config.getSandPileAccumulationHeight();
        if (!config.isSandPileAccumulationEnabled() || accumulationHeight <= 0) {
            return;
        }

        if (canSetSand(world, topPos, sandPileBlock)) {
            class_2680 sandPileState = sandPileBlock.method_9564();
            class_2680 currentState = world.method_8320(topPos);

            if (currentState.method_27852(sandPileBlock)) {
                int currentLayers = currentState.method_11654(SandPileBlock.LAYERS);

                if (currentLayers < Math.min(accumulationHeight, SandPileBlock.MAX_LAYERS)) {
                    sandPileState = currentState.method_11657(class_2488.field_11518, currentLayers + 1);
                    class_2248.method_9582(currentState, sandPileState, world, topPos);
                }

            }
            world.method_8501(topPos, sandPileState);
        }
    }

    private static boolean canSetSand(class_3218 world, class_2338 pos, class_2248 sandPileBlock) {
        class_2680 current = world.method_8320(pos);
        return pos.method_10264() >= world.method_31607()
                && pos.method_10264() < world.method_31600()
                && (current.method_26215() || current.method_27852(sandPileBlock))
                && sandPileBlock.method_9564().method_26184(world, pos);
    }

    private SandAccumulation() {

    }
}
