package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5699;

public class ChangeTemperatureEffect extends TemperatureEffect<ChangeTemperatureEffect.Config> {

    /**
     * @param configCodec Codec for the config type
     */
    public ChangeTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        victim.thermoo$addTemperature(config.temperatureChange(), config.heatingMode());
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % config.interval() == 0;
    }

    public record Config(
            int temperatureChange,
            int interval,
            HeatingModes heatingMode
    ) {
        public static final Codec<HeatingModes> HEATING_MODES_CODEC = class_3542.method_28140(HeatingModes::values);

        public static final Codec<Config> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                        Codec.INT
                                .fieldOf("temperature_change")
                                .forGetter(Config::temperatureChange),
                        class_5699.field_33442
                                .fieldOf("interval")
                                .forGetter(Config::interval),
                        HEATING_MODES_CODEC
                                .lenientOptionalFieldOf("heating_mode", HeatingModes.ABSOLUTE)
                                .forGetter(Config::heatingMode)
                ).apply(instance, Config::new)
        );
    }
}