package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SBlockTags;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.RelativeHumidityComponent;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public final class PassiveTemperatureEffects {
    private static final double LOW_HUMIDITY = 0.2;
    private static final double HIGH_HUMIDITY = 0.65;
    private static final double VERY_HIGH_HUMIDITY = 0.8;

    public static void initialize() {
        LivingEntityTemperatureTickEvents.GET_PASSIVE_TEMPERATURE_CHANGE.register(PassiveTemperatureEffects::getPassiveChange);
    }

    private static int getPassiveChange(EnvironmentTickContext<? extends class_1309> context) {
        class_1309 entity = context.affected();

        // don't touch frostiful's effects
        if (entity.method_7325() || entity.thermoo$getTemperature() < 0) {
            return 0;
        }

        int total = 0;

        ScorchfulConfig config = Scorchful.getConfig();
        total += getIcyFloorTemperatureChange(context, config);
        total += getTemperatureFromSweat(context, config);

        return total;
    }

    private static int getIcyFloorTemperatureChange(EnvironmentTickContext<? extends class_1309> context, ScorchfulConfig config) {
        class_1309 entity = context.affected();
        class_2680 steppingState = entity.method_25936();

        if (steppingState.method_26164(SBlockTags.HEAVY_ICE) && entity.thermoo$isWarm()) {
            return -config.heatingConfig.getCoolingFromIce();
        }

        return 0;
    }

    private static int getTemperatureFromSweat(EnvironmentTickContext<? extends class_1309> context, ScorchfulConfig config) {
        class_1309 entity = context.affected();
        if (entity.thermoo$isWet()) {
            int temperatureChange = config.thirstConfig.getTemperatureFromWetness();
            if (!context.affected().method_5869()) {
                float efficiency = getSweatEfficiency(context, config);
                temperatureChange = class_3532.method_15375(temperatureChange * efficiency);
            }
            return temperatureChange;
        }

        return 0;
    }

    private static float getSweatEfficiency(EnvironmentTickContext<? extends class_1309> context, ScorchfulConfig config) {
        double relativeHumidity = context.components().method_57830(EnvironmentComponentTypes.RELATIVE_HUMIDITY, RelativeHumidityComponent.DEFAULT);
        if (relativeHumidity <= LOW_HUMIDITY) {
            return config.thirstConfig.getAridBiomeSweatEfficiency();
        } else if (relativeHumidity >= VERY_HIGH_HUMIDITY) {
            return config.thirstConfig.getExtraHumidBiomeSweatEfficiency();
        } else if (relativeHumidity >= HIGH_HUMIDITY) {
            return config.thirstConfig.getHumidBiomeSweatEfficiency();
        } else {
            return 1f;
        }
    }

    private PassiveTemperatureEffects() {

    }
}