package com.github.thedeathlycow.scorchful.temperature.environment.provider;

import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2096;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public record CheckTimeEnvironmentProvider(
        class_2096.class_2100 timeRange,
        class_6880<EnvironmentProvider> in,
        class_6880<EnvironmentProvider> out
) implements EnvironmentProvider {
    public static final MapCodec<CheckTimeEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_2096.class_2100.field_45763
                            .fieldOf("time_range")
                            .forGetter(CheckTimeEnvironmentProvider::timeRange),
                    EnvironmentProvider.ENTRY_CODEC
                            .fieldOf("in")
                            .forGetter(CheckTimeEnvironmentProvider::in),
                    EnvironmentProvider.ENTRY_CODEC
                            .fieldOf("out")
                            .forGetter(CheckTimeEnvironmentProvider::out)
            ).apply(instance, CheckTimeEnvironmentProvider::new)
    );

    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        long time = world.method_8532();
        if (timeRange.method_9054((int) time)) {
            in.comp_349().buildCurrentComponents(world, pos, biome, builder);
        } else {
            out.comp_349().buildCurrentComponents(world, pos, biome, builder);
        }
    }

    @Override
    public EnvironmentProviderType<CheckTimeEnvironmentProvider> getType() {
        return SEnvironmentProviderTypes.CHECK_TIME;
    }
}