package com.github.thedeathlycow.scorchful.temperature.environment.provider;

import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.RelativeHumidityComponent;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public record RelativeHumidityThresholdEnvironmentProvider(
        double relativeHumidityThreshold,
        class_6880<EnvironmentProvider> above,
        class_6880<EnvironmentProvider> below
) implements EnvironmentProvider {
    public static final MapCodec<RelativeHumidityThresholdEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                RelativeHumidityComponent.CODEC
                        .fieldOf("relative_humidity_threshold")
                        .forGetter(RelativeHumidityThresholdEnvironmentProvider::relativeHumidityThreshold),
                    EnvironmentProvider.ENTRY_CODEC
                            .fieldOf("above")
                            .forGetter(RelativeHumidityThresholdEnvironmentProvider::above),
                    EnvironmentProvider.ENTRY_CODEC
                            .fieldOf("below")
                            .forGetter(RelativeHumidityThresholdEnvironmentProvider::below)
            ).apply(instance, RelativeHumidityThresholdEnvironmentProvider::new)
    );

    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        double relativeHumidity = builder.getOrDefault(EnvironmentComponentTypes.RELATIVE_HUMIDITY, RelativeHumidityComponent.DEFAULT);
        if (relativeHumidity >= relativeHumidityThreshold) {
            above.comp_349().buildCurrentComponents(world, pos, biome, builder);
        } else {
            below.comp_349().buildCurrentComponents(world, pos, biome, builder);
        }
    }

    @Override
    public EnvironmentProviderType<RelativeHumidityThresholdEnvironmentProvider> getType() {
        return SEnvironmentProviderTypes.RELATIVE_HUMIDITY_THRESHOLD;
    }
}