package com.github.thedeathlycow.scorchful.temperature.environment.provider;

import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3215;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public record SeaLevelAltitudeTemperatureEnvironmentProvider(
        TemperatureRecord temperatureAtSeaLevel,
        TemperatureRecord temperatureDecreasePerBlock,
        int maxElevation
) implements EnvironmentProvider {
    public static final MapCodec<SeaLevelAltitudeTemperatureEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    TemperatureRecord.CODEC
                            .fieldOf("temperature_at_sea_level")
                            .forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::temperatureAtSeaLevel),
                    TemperatureRecord.CODEC
                            .fieldOf("temperature_decrease_per_block")
                            .forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::temperatureDecreasePerBlock),
                    class_5699.field_33442
                            .fieldOf("max_elevation")
                            .orElse(Integer.MAX_VALUE)
                            .forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::maxElevation)
            ).apply(instance, SeaLevelAltitudeTemperatureEnvironmentProvider::new)
    );

    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        // assume no sea level
        int distanceToSeaLevel = Integer.MAX_VALUE;

        // generally this should be true, since we always execute on the server
        if (world.method_8398() instanceof class_3215 serverChunkManager) {
            int height = pos.method_10264();
            int seaLevel = serverChunkManager.method_12129().method_16398();

            distanceToSeaLevel = Math.clamp(height - seaLevel, 0, maxElevation);
        }

        double temperature = temperatureAtSeaLevel.valueInUnit(temperatureDecreasePerBlock.unit());

        if (distanceToSeaLevel > 0) {
            temperature += distanceToSeaLevel * temperatureDecreasePerBlock.value();
        }

        builder.method_57840(
                EnvironmentComponentTypes.TEMPERATURE,
                new TemperatureRecord(temperature, temperatureDecreasePerBlock.unit())
        );
    }

    @Override
    public EnvironmentProviderType<SeaLevelAltitudeTemperatureEnvironmentProvider> getType() {
        return SEnvironmentProviderTypes.SEA_LEVEL_ALTITUDE_TEMPERATURE;
    }
}