/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful;

import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.compat.DehydrationServerThirstPlugin;
import com.github.thedeathlycow.scorchful.compat.ScorchfulIntegrations;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.SArmorMaterials;
import com.github.thedeathlycow.scorchful.registry.SBlockEntityTypes;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.registry.SEntityTypes;
import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.scorchful.registry.SHeatVisions;
import com.github.thedeathlycow.scorchful.registry.SItemGroups;
import com.github.thedeathlycow.scorchful.registry.SItems;
import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.github.thedeathlycow.scorchful.registry.SPointsOfInterest;
import com.github.thedeathlycow.scorchful.registry.SPotions;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.SStats;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.registry.STemperatureEffects;
import com.github.thedeathlycow.scorchful.server.ThirstCommand;
import com.github.thedeathlycow.scorchful.server.network.TemperatureSoundEventPacket;
import com.github.thedeathlycow.scorchful.temperature.ActiveTemperatureEffects;
import com.github.thedeathlycow.scorchful.temperature.PassiveTemperatureEffects;
import com.github.thedeathlycow.scorchful.temperature.ServerPlayerEnvironmentTickListeners;
import com.github.thedeathlycow.scorchful.temperature.SoakingEffects;
import com.github.thedeathlycow.scorchful.worldgen.NetherBiomeModifications;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scorchful
implements ModInitializer {
    public static final String MODID = "scorchful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scorchful");
    public static final int CONFIG_VERSION = 6;
    private static ConfigHolder<ScorchfulConfig> configHolder = null;

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public void onInitialize() {
        AutoConfig.register(ScorchfulConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(ScorchfulConfig.class);
        ScorchfulConfig.updateConfig(configHolder);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ThirstCommand.register((CommandDispatcher<class_2168>)dispatcher));
        }
        SArmorMaterials.initialize();
        SBlocks.initialize();
        SBlockEntityTypes.initialize();
        SDataComponentTypes.initialize();
        SItems.initialize();
        SEntityTypes.initialize();
        SPotions.initialize();
        SItemGroups.initialize();
        SSoundEvents.initialize();
        STemperatureEffects.initialize();
        SStatusEffects.initialize();
        SParticleTypes.initialize();
        NetherBiomeModifications.initialize();
        SStats.initialize();
        SHeatVisions.initialize();
        SEnvironmentProviderTypes.initialize();
        SEntityAttributes.initialize();
        SPointsOfInterest.initialize();
        if (ScorchfulIntegrations.isDehydrationLoaded() && !ServerThirstPlugin.isCustomPluginLoaded()) {
            LOGGER.debug("Applying Dehydration thirst plugin");
            ServerThirstPlugin.registerPlugin(new DehydrationServerThirstPlugin());
        }
        this.registerThermooEventListeners();
        PayloadTypeRegistry.playS2C().register(TemperatureSoundEventPacket.PACKET_ID, TemperatureSoundEventPacket.PACKET_CODEC);
        LOGGER.info("Scorchful initialized!");
    }

    @NotNull
    public static ScorchfulConfig getConfig() {
        return (ScorchfulConfig)configHolder.getConfig();
    }

    private void registerThermooEventListeners() {
        ServerPlayerEnvironmentTickListeners.initialize();
        ActiveTemperatureEffects.initialize();
        PassiveTemperatureEffects.initialize();
        SoakingEffects.initialize();
    }
}

