/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.block.SandPileBlock;
import com.github.thedeathlycow.scorchful.config.WeatherConfig;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class SandAccumulation {
    public static final Map<Sandstorms.SandstormType, class_2248> SAND_PILES = (Map)class_156.method_656(() -> {
        EnumMap<Sandstorms.SandstormType, class_2248> map = new EnumMap<Sandstorms.SandstormType, class_2248>(Sandstorms.SandstormType.class);
        map.put(Sandstorms.SandstormType.REGULAR, SBlocks.SAND_PILE);
        map.put(Sandstorms.SandstormType.RED, SBlocks.RED_SAND_PILE);
        return map;
    });
    public static final Map<Sandstorms.SandstormType, class_2248> SAND_CAULDRONS = (Map)class_156.method_656(() -> {
        EnumMap<Sandstorms.SandstormType, class_2248> map = new EnumMap<Sandstorms.SandstormType, class_2248>(Sandstorms.SandstormType.class);
        map.put(Sandstorms.SandstormType.REGULAR, SBlocks.SAND_CAULDRON);
        map.put(Sandstorms.SandstormType.RED, SBlocks.RED_SAND_CAULDRON);
        return map;
    });

    public static void tickChunk(class_3218 world, class_2818 chunk, int randomTickSpeed) {
        class_1923 chunkPos = chunk.method_12004();
        class_2338 topPos = world.method_8598(class_2902.class_2903.field_13197, world.method_8536(chunkPos.method_8326(), 0, chunkPos.method_8328(), 15));
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm((class_1937)world, topPos);
        if (sandstorm == Sandstorms.SandstormType.NONE) {
            return;
        }
        class_5819 random = world.field_9229;
        if (random.method_43048(16) != 0) {
            return;
        }
        class_2248 sandPile = SAND_PILES.get((Object)sandstorm);
        if (sandPile == null) {
            return;
        }
        WeatherConfig config = Scorchful.getConfig().weatherConfig;
        SandAccumulation.placeSandPile(world, topPos, sandPile, config);
        class_2338 groundPos = topPos.method_10074();
        class_2680 groundState = world.method_8320(groundPos);
        class_2248 groundBlock = groundState.method_26204();
        groundBlock.method_9504(groundState, (class_1937)world, groundPos, class_1959.class_1963.field_9384);
    }

    public static boolean cauldronSandstormTick(class_2680 state, class_1937 world, class_2338 pos) {
        Sandstorms.SandstormType sandstorm = Sandstorms.getCurrentSandStorm(world, pos.method_10084());
        class_2248 cauldron = SAND_CAULDRONS.get((Object)sandstorm);
        if (cauldron != null) {
            world.method_8501(pos, cauldron.method_9564());
            world.method_33596(null, (class_6880)class_5712.field_28733, pos);
            return true;
        }
        return false;
    }

    private static void placeSandPile(class_3218 world, class_2338 topPos, class_2248 sandPileBlock, WeatherConfig config) {
        int accumulationHeight = config.getSandPileAccumulationHeight();
        if (!config.isSandPileAccumulationEnabled() || accumulationHeight <= 0) {
            return;
        }
        if (SandAccumulation.canSetSand(world, topPos, sandPileBlock)) {
            int currentLayers;
            class_2680 sandPileState = sandPileBlock.method_9564();
            class_2680 currentState = world.method_8320(topPos);
            if (currentState.method_27852(sandPileBlock) && (currentLayers = ((Integer)currentState.method_11654((class_2769)SandPileBlock.LAYERS)).intValue()) < Math.min(accumulationHeight, 8)) {
                sandPileState = (class_2680)currentState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(currentLayers + 1));
                class_2248.method_9582((class_2680)currentState, (class_2680)sandPileState, (class_1936)world, (class_2338)topPos);
            }
            world.method_8501(topPos, sandPileState);
        }
    }

    private static boolean canSetSand(class_3218 world, class_2338 pos, class_2248 sandPileBlock) {
        class_2680 current = world.method_8320(pos);
        return pos.method_10264() >= world.method_31607() && pos.method_10264() < world.method_31600() && (current.method_26215() || current.method_27852(sandPileBlock)) && sandPileBlock.method_9564().method_26184((class_4538)world, pos);
    }

    private SandAccumulation() {
    }
}

