/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature.environment.provider;

import com.github.thedeathlycow.scorchful.registry.SEnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public record SeaLevelAltitudeTemperatureEnvironmentProvider(TemperatureRecord temperatureAtSeaLevel, TemperatureRecord temperatureDecreasePerBlock, int maxElevation) implements EnvironmentProvider
{
    public static final MapCodec<SeaLevelAltitudeTemperatureEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TemperatureRecord.CODEC.fieldOf("temperature_at_sea_level").forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::temperatureAtSeaLevel), (App)TemperatureRecord.CODEC.fieldOf("temperature_decrease_per_block").forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::temperatureDecreasePerBlock), (App)class_5699.field_33442.fieldOf("max_elevation").orElse((Object)Integer.MAX_VALUE).forGetter(SeaLevelAltitudeTemperatureEnvironmentProvider::maxElevation)).apply((Applicative)instance, SeaLevelAltitudeTemperatureEnvironmentProvider::new));

    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        int distanceToSeaLevel = Integer.MAX_VALUE;
        class_2802 class_28022 = world.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 serverChunkManager = (class_3215)class_28022;
            int height = pos.method_10264();
            int seaLevel = serverChunkManager.method_12129().method_16398();
            distanceToSeaLevel = Math.clamp((long)(height - seaLevel), 0, this.maxElevation);
        }
        double temperature = this.temperatureAtSeaLevel.valueInUnit(this.temperatureDecreasePerBlock.unit());
        if (distanceToSeaLevel > 0) {
            temperature += (double)distanceToSeaLevel * this.temperatureDecreasePerBlock.value();
        }
        builder.method_57840(EnvironmentComponentTypes.TEMPERATURE, (Object)new TemperatureRecord(temperature, this.temperatureDecreasePerBlock.unit()));
    }

    public EnvironmentProviderType<SeaLevelAltitudeTemperatureEnvironmentProvider> getType() {
        return SEnvironmentProviderTypes.SEA_LEVEL_ALTITUDE_TEMPERATURE;
    }
}

