/*
 * Decompiled with CFR 0.152.
 */
package dev.jqve.serverscanner.screens;

import dev.jqve.serverscanner.mixin.MultiplayerScreenInvoker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_5348;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortScannerScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger(PortScannerScreen.class);
    private static final int TIMEOUT_MS = 150;
    private static final int THREAD_POOL_SIZE = 25;
    private static final Pattern IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private class_342 ipTextField;
    private class_342 startPortTextField;
    private class_342 endPortTextField;
    private class_4185 scanButton;
    private class_2561 statusText;
    private final List<Integer> openPorts = new ArrayList<Integer>();
    private final List<class_642> foundServers = new ArrayList<class_642>();
    private ExecutorService executorService;
    private boolean isScanning = false;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 4;
    private static final int RESULTS_START_Y = 120;
    private int buttonsPerRow;
    private int dynamicButtonWidth;

    public PortScannerScreen() {
        super((class_2561)class_2561.method_43470((String)"Minecraft Server Scanner"));
    }

    protected void method_25426() {
        this.calculateLayoutMetrics();
        this.initializeTextFields();
        this.initializeButtons();
        this.statusText = class_2561.method_43470((String)"");
    }

    private void calculateLayoutMetrics() {
        int totalWidth = this.field_22789 - 40;
        if (totalWidth < 1) {
            totalWidth = 1;
        }
        int approximateButtonWidth = 200;
        this.buttonsPerRow = Math.max(1, totalWidth / (approximateButtonWidth + 4));
        int totalSpacing = 4 * (this.buttonsPerRow - 1);
        int spaceForButtons = totalWidth - totalSpacing;
        int fullWidth = Math.max(50, spaceForButtons / this.buttonsPerRow);
        this.dynamicButtonWidth = (int)((double)fullWidth * 0.5);
    }

    private void initializeTextFields() {
        this.ipTextField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 20, 200, 20, (class_2561)class_2561.method_43470((String)"IP Address"));
        this.ipTextField.method_1880(15);
        this.ipTextField.method_1852("127.0.0.1");
        this.ipTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enter the IP address to scan (e.g., 127.0.0.1)")));
        this.method_37063((class_364)this.ipTextField);
        this.startPortTextField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 50, 90, 20, (class_2561)class_2561.method_43470((String)"Start Port"));
        this.startPortTextField.method_1880(5);
        this.startPortTextField.method_1852("1");
        this.startPortTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enter the starting port number (lowest port to scan)")));
        this.method_37063((class_364)this.startPortTextField);
        this.endPortTextField = new class_342(this.field_22793, this.field_22789 / 2 + 10, 50, 90, 20, (class_2561)class_2561.method_43470((String)"End Port"));
        this.endPortTextField.method_1880(5);
        this.endPortTextField.method_1852("65535");
        this.endPortTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enter the ending port number (highest port to scan)")));
        this.method_37063((class_364)this.endPortTextField);
    }

    private void initializeButtons() {
        this.scanButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Scan Ports"), this::handleScanButton).method_46432(200).method_46433(this.field_22789 / 2 - 100, 80).method_46431();
        this.method_37063((class_364)this.scanButton);
    }

    private void handleScanButton(class_4185 button) {
        if (this.isScanning) {
            this.stopScanning();
        } else {
            this.startScanning();
        }
    }

    private void startScanning() {
        if (!this.validateInput()) {
            return;
        }
        String ip = this.ipTextField.method_1882();
        int startPort = Integer.parseInt(this.startPortTextField.method_1882());
        int endPort = Integer.parseInt(this.endPortTextField.method_1882());
        this.isScanning = true;
        this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Stop Scanning"));
        this.openPorts.clear();
        this.foundServers.clear();
        this.updateServerButtons();
        this.executorService = Executors.newFixedThreadPool(25);
        this.scanPorts(ip, startPort, endPort);
    }

    private void stopScanning() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.isScanning = false;
        this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Scan Ports"));
        this.statusText = class_2561.method_43470((String)"Scanning stopped");
    }

    private boolean validateInput() {
        try {
            String ip = this.ipTextField.method_1882();
            int startPort = Integer.parseInt(this.startPortTextField.method_1882());
            int endPort = Integer.parseInt(this.endPortTextField.method_1882());
            if (!IP_PATTERN.matcher(ip).matches()) {
                this.statusText = class_2561.method_43470((String)"\u00a7cInvalid IP address format");
                return false;
            }
            if (startPort < 1 || startPort > 65535 || endPort < 1 || endPort > 65535) {
                this.statusText = class_2561.method_43470((String)"\u00a7cPorts must be between 1 and 65535");
                return false;
            }
            if (startPort > endPort) {
                this.statusText = class_2561.method_43470((String)"\u00a7cStart port must be \u2264 end port");
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.statusText = class_2561.method_43470((String)"\u00a7cInvalid port numbers");
            return false;
        }
    }

    private void scanPorts(String ip, int startPort, int endPort) {
        ConcurrentLinkedQueue portQueue = new ConcurrentLinkedQueue();
        AtomicInteger processedPorts = new AtomicInteger(0);
        int totalPorts = endPort - startPort + 1;
        int port = startPort;
        while (port <= endPort) {
            int currentPort = port++;
            this.executorService.submit(() -> {
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress(ip, currentPort), 150);
                    portQueue.add(currentPort);
                    LOGGER.info("Found open port {} on {}", (Object)currentPort, (Object)ip);
                }
                catch (IOException processed) {
                }
                finally {
                    int processed = processedPorts.incrementAndGet();
                    this.updateProgress(processed, totalPorts);
                }
            });
        }
        new Thread(() -> {
            while (!Thread.currentThread().isInterrupted() && processedPorts.get() < totalPorts) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            class_310.method_1551().execute(() -> {
                this.openPorts.addAll(portQueue);
                for (Integer p : this.openPorts) {
                    this.foundServers.add(new class_642(ip + ":" + p, ip + ":" + p, class_642.class_8678.field_45609));
                }
                this.updateServerButtons();
                this.isScanning = false;
                this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Scan Ports"));
                this.statusText = class_2561.method_43470((String)("\u00a7aScanning completed! Found " + this.openPorts.size() + " open ports"));
            });
        }).start();
    }

    private void updateProgress(int processed, int total) {
        float progress = (float)processed / (float)total * 100.0f;
        class_310.method_1551().execute(() -> {
            String statusString = String.format("Scanning: %.1f%% (%d/%d)", Float.valueOf(progress), processed, total);
            this.statusText = class_2561.method_43470((String)statusString);
        });
    }

    private void updateServerButtons() {
        this.method_25396().removeIf(child -> child instanceof class_4185 && ((class_4185)child).method_25369().getString().contains(":"));
        if (this.foundServers.isEmpty()) {
            return;
        }
        this.calculateLayoutMetrics();
        int totalServers = this.foundServers.size();
        int totalRows = (int)Math.ceil((double)totalServers / (double)this.buttonsPerRow);
        int totalBlockWidth = this.buttonsPerRow * this.dynamicButtonWidth + (this.buttonsPerRow - 1) * 4;
        int offsetX = (this.field_22789 - totalBlockWidth) / 2;
        for (int index = 0; index < this.foundServers.size(); ++index) {
            class_642 server = this.foundServers.get(index);
            int row = index / this.buttonsPerRow;
            int col = index % this.buttonsPerRow;
            int buttonX = offsetX + col * (this.dynamicButtonWidth + 4);
            int buttonY = 120 + row * 24;
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)server.field_3752), b -> this.addServerToList(server)).method_46432(this.dynamicButtonWidth).method_46433(buttonX, buttonY).method_46431();
            this.method_37063((class_364)button);
        }
    }

    private void addServerToList(class_642 server) {
        class_310 client = class_310.method_1551();
        class_500 multiplayerScreen = new class_500((class_437)this);
        multiplayerScreen.method_25423(client, this.field_22789, this.field_22790);
        class_641 serverList = new class_641(client);
        serverList.method_2981();
        MultiplayerScreenInvoker invoker = (MultiplayerScreenInvoker)multiplayerScreen;
        invoker.setServerList(serverList);
        invoker.setSelectedEntry(server);
        invoker.invokeAddEntry(true);
        client.method_1507((class_437)this);
        this.foundServers.remove(server);
        this.updateServerButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, this.field_22785, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 5, 0xFFFFFF);
        if (this.statusText != null) {
            context.method_27535(this.field_22793, this.statusText, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.statusText) / 2, 110, 0xFFFFFF);
        }
    }

    public void method_25432() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        super.method_25432();
    }

    public void method_25410(class_310 client, int width, int height) {
        String tempIp = this.ipTextField != null ? this.ipTextField.method_1882() : "";
        String tempStart = this.startPortTextField != null ? this.startPortTextField.method_1882() : "";
        String tempEnd = this.endPortTextField != null ? this.endPortTextField.method_1882() : "";
        this.method_25423(client, width, height);
        this.ipTextField.method_1852(tempIp);
        this.startPortTextField.method_1852(tempStart);
        this.endPortTextField.method_1852(tempEnd);
        this.updateServerButtons();
    }
}

