/*
 * Decompiled with CFR 0.152.
 */
package dev.jqve.serverscanner.screens;

import dev.jqve.serverscanner.mixin.MultiplayerScreenInvoker;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_5348;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerScannerScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger(ServerScannerScreen.class);
    private static final int TIMEOUT_MS = 200;
    private static final int THREAD_POOL_SIZE = 50;
    private static final int DEFAULT_MINECRAFT_PORT = 25565;
    private static final int SCAN_RANGE_START = 1;
    private static final int SCAN_RANGE_END = 254;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 4;
    private static final int RESULTS_START_Y = 120;
    private static final int TEXT_FIELD_WIDTH = 200;
    private static final Pattern IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private final class_437 parent;
    private final Set<class_642> foundServers = Collections.synchronizedSet(new LinkedHashSet());
    private final Queue<Runnable> uiUpdateQueue = new ConcurrentLinkedQueue<Runnable>();
    private final List<class_4185> serverButtons = new ArrayList<class_4185>();
    private class_342 ipTextField;
    private class_4185 scanButton;
    private class_2561 statusText;
    private ExecutorService executorService;
    private ScheduledExecutorService uiUpdateExecutor;
    private volatile boolean isScanning;
    private String savedIpText = "";
    private int buttonsPerRow;
    private int dynamicButtonWidth;
    private static final int MAX_VISIBLE_ROWS = 2;
    private int totalRows;
    private int scrollOffset = 0;
    private final int scrollSpeed = 10;

    public ServerScannerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Minecraft Server Scanner"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.saveCurrentState();
        this.calculateLayoutMetrics();
        this.initializeTextFields();
        this.initializeButtons();
        this.restoreState();
        this.startUiUpdateThread();
    }

    private void calculateLayoutMetrics() {
        int totalWidth = this.field_22789 - 40;
        if (totalWidth < 1) {
            totalWidth = 1;
        }
        int approximateButtonWidth = 180;
        this.buttonsPerRow = Math.max(1, totalWidth / (approximateButtonWidth + 4));
        int spaceForButtons = totalWidth - 4 * (this.buttonsPerRow - 1);
        this.dynamicButtonWidth = Math.max(50, spaceForButtons / this.buttonsPerRow);
    }

    private void saveCurrentState() {
        if (this.ipTextField != null) {
            this.savedIpText = this.ipTextField.method_1882();
        }
    }

    private void initializeTextFields() {
        this.ipTextField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 20, 200, 20, (class_2561)class_2561.method_43470((String)"IP Address"));
        this.ipTextField.method_1880(15);
        this.ipTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enter IP address (e.g., 192.168.1.1)")));
        this.method_37063((class_364)this.ipTextField);
    }

    private String getNetworkAddress(String ip) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(addr);
            if (networkInterface != null) {
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (!(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                    short prefix = interfaceAddress.getNetworkPrefixLength();
                    byte[] bytes = addr.getAddress();
                    int mask = -1 << 32 - prefix;
                    int network = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
                    return String.format("%d.%d.%d.", (network &= mask) >>> 24 & 0xFF, network >>> 16 & 0xFF, network >>> 8 & 0xFF);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error determining network address", (Throwable)e);
        }
        return ip.substring(0, ip.lastIndexOf(46) + 1);
    }

    private void clearServerButtons() {
        for (class_4185 button : this.serverButtons) {
            this.method_37066((class_364)button);
        }
        this.serverButtons.clear();
    }

    private void initializeButtons() {
        this.scanButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Scan Network"), this::handleScanButton).method_46432(200).method_46433(this.field_22789 / 2 - 100, 50).method_46431();
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> class_310.method_1551().method_1507(this.parent)).method_46432(50).method_46433(5, 5).method_46431();
        this.method_37063((class_364)this.scanButton);
        this.method_37063((class_364)backButton);
    }

    private void restoreState() {
        this.statusText = class_2561.method_43470((String)"");
        this.ipTextField.method_1852(this.savedIpText.isEmpty() ? "192.168.1.1" : this.savedIpText);
    }

    private void startUiUpdateThread() {
        this.uiUpdateExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "UI-Update-Thread");
            thread.setDaemon(true);
            return thread;
        });
        this.uiUpdateExecutor.scheduleAtFixedRate(() -> {
            while (!this.uiUpdateQueue.isEmpty()) {
                Runnable update = this.uiUpdateQueue.poll();
                if (update == null) continue;
                class_310.method_1551().execute(update);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    private void handleScanButton(class_4185 button) {
        if (this.isScanning) {
            this.stopScanning();
        } else {
            this.startScanning();
        }
    }

    private void startScanning() {
        String ip = this.ipTextField.method_1882().trim();
        if (!this.validateInput(ip)) {
            return;
        }
        String networkIp = this.getNetworkAddress(ip);
        this.isScanning = true;
        this.foundServers.clear();
        this.clearServerButtons();
        this.queueUiUpdate(() -> {
            this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Stop Scanning"));
            this.updateServerList();
        });
        this.executorService = Executors.newFixedThreadPool(50, r -> {
            Thread thread = new Thread(r, "Server-Scanner-Thread");
            thread.setDaemon(true);
            return thread;
        });
        this.scanNetwork(networkIp);
    }

    private void stopScanning() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.isScanning = false;
        this.queueUiUpdate(() -> {
            this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Scan Network"));
            this.statusText = class_2561.method_43470((String)"\u00a7cScanning stopped");
        });
    }

    private boolean validateInput(String ip) {
        if (!IP_PATTERN.matcher(ip).matches()) {
            this.setStatusText("\u00a7cInvalid IP address format");
            return false;
        }
        return true;
    }

    private void scanNetwork(String baseIp) {
        AtomicInteger processedIps = new AtomicInteger(0);
        int totalIps = 254;
        CompletableFuture<Void> scanTask = CompletableFuture.runAsync(() -> {
            int i = 1;
            while (i <= 254 && this.isScanning) {
                String ip = baseIp + i;
                int currentNumber = i++;
                CompletableFuture.runAsync(() -> {
                    try {
                        if (this.isPortOpen(ip)) {
                            class_642 server = new class_642("Server #" + currentNumber, ip + ":25565", class_642.class_8678.field_45609);
                            this.foundServers.add(server);
                            LOGGER.info("Found server at {}", (Object)ip);
                            this.queueUiUpdate(this::updateServerList);
                        }
                    }
                    finally {
                        int processed = processedIps.incrementAndGet();
                        this.updateProgress(processed, totalIps);
                    }
                }, this.executorService);
            }
        }, this.executorService);
        scanTask.whenComplete((result, exception) -> {
            if (exception != null) {
                LOGGER.error("Error during scanning", exception);
                this.setStatusText("\u00a7cError during scanning");
            }
            this.completeScan();
        });
    }

    private boolean isPortOpen(String ip) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(ip, 25565), 200);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private void updateProgress(int processed, int total) {
        float progress = (float)processed / (float)total * 100.0f;
        this.setStatusText(String.format("\u00a7eScanning: %.1f%% (%d/%d)", Float.valueOf(progress), processed, total));
    }

    private void completeScan() {
        if (!this.isScanning) {
            return;
        }
        this.queueUiUpdate(() -> {
            this.isScanning = false;
            this.scanButton.method_25355((class_2561)class_2561.method_43470((String)"Scan Network"));
            this.statusText = class_2561.method_43470((String)("\u00a7aScanning completed! Found " + this.foundServers.size() + " servers"));
            this.updateServerList();
        });
    }

    private void updateServerList() {
        this.clearServerButtons();
        if (this.foundServers.isEmpty()) {
            return;
        }
        int serverCount = this.foundServers.size();
        this.totalRows = (int)Math.ceil((double)serverCount / (double)this.buttonsPerRow);
        int idx = 0;
        int buttonYStart = 120 - this.scrollOffset;
        for (class_642 server : this.foundServers) {
            int row = idx / this.buttonsPerRow;
            int col = idx % this.buttonsPerRow;
            int buttonY = buttonYStart + row * 24;
            int buttonX = 20 + col * (this.dynamicButtonWidth + 4);
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)server.field_3752), btn -> this.addServerToList(server)).method_46432(this.dynamicButtonWidth).method_46433(buttonX, buttonY).method_46431();
            this.serverButtons.add(button);
            this.method_37063((class_364)button);
            ++idx;
        }
    }

    private void addServerToList(class_642 server) {
        class_310 client = class_310.method_1551();
        class_500 multiplayerScreen = new class_500((class_437)this);
        multiplayerScreen.method_25423(client, this.field_22789, this.field_22790);
        class_641 serverList = new class_641(client);
        serverList.method_2981();
        MultiplayerScreenInvoker invoker = (MultiplayerScreenInvoker)multiplayerScreen;
        invoker.setServerList(serverList);
        invoker.setSelectedEntry(server);
        invoker.invokeAddEntry(true);
        client.method_1507((class_437)this);
        this.foundServers.remove(server);
        this.updateServerList();
    }

    private void queueUiUpdate(Runnable update) {
        this.uiUpdateQueue.offer(update);
    }

    private void setStatusText(String message) {
        this.queueUiUpdate(() -> {
            this.statusText = class_2561.method_43470((String)message);
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int maxRowsVisible = 2;
        if (this.totalRows > maxRowsVisible) {
            int totalHeight = this.totalRows * 24;
            int maxVisibleHeight = maxRowsVisible * 24;
            int maxScroll = Math.max(0, totalHeight - maxVisibleHeight);
            this.scrollOffset = (int)((double)this.scrollOffset - amount * 10.0);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
            this.updateServerList();
        }
        return super.method_25401(mouseX, mouseY, amount, amount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, this.field_22785, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 5, 0xFFFFFF);
        if (this.statusText != null) {
            context.method_27535(this.field_22793, this.statusText, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.statusText) / 2, 80, 0xFFFFFF);
        }
    }

    public void method_25432() {
        this.stopScanning();
        if (this.uiUpdateExecutor != null) {
            this.uiUpdateExecutor.shutdownNow();
            this.uiUpdateExecutor = null;
        }
        super.method_25432();
    }

    public void method_25410(class_310 client, int width, int height) {
        String text = this.ipTextField != null ? this.ipTextField.method_1882() : "";
        this.method_25423(client, width, height);
        this.ipTextField.method_1852(text);
        this.updateServerList();
    }
}

